/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.TestDatabase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.beans.Database;
import org.apache.openejb.test.beans.DatabaseHome;

public class InstantDbTestDatabase
implements TestDatabase {
    protected Database database;
    protected InitialContext initialContext;
    private static String _createAccount = "CREATE TABLE account ( ssn CHAR(11) PRIMARY KEY, first_name CHAR(20), last_name CHAR(20), balance INT)";
    private static String _dropAccount = "DROP TABLE account";
    private static String _createEntity = "CREATE TABLE entity ( id INT PRIMARY KEY AUTO INCREMENT, first_name CHAR(20), last_name CHAR(20) )";
    private static String _dropEntity = "DROP TABLE entity";
    private static final String CREATE_ONE_TO_ONE_A = "CREATE TABLE OneToOneA(A1 INTEGER, A2 VARCHAR(50))";
    private static final String DROP_ONE_TO_ONE_A = "DROP TABLE OneToOneA";
    private static final String CREATE_ONE_TO_ONE_B = "CREATE TABLE OneToOneB(B1 INTEGER, B2 VARCHAR(50), B3 INTEGER, B4 VARCHAR(50), FKA1 INTEGER)";
    private static final String DROP_ONE_TO_ONE_B = "DROP TABLE OneToOneB";
    private static final String CREATE_ONE_OWNING = "CREATE TABLE oneowning (col_id INTEGER, col_field1 INTEGER)";
    private static final String DROP_ONE_OWNING = "DROP TABLE oneowning";
    private static final String CREATE_ONE_INVERSE = "CREATE TABLE oneinverse (col_id INTEGER)";
    private static final String DROP_ONE_INVERSE = "DROP TABLE oneinverse";
    private static final String CREATE_MANY_OWNING = "CREATE TABLE manyowning (col_id INTEGER, col_field1 INTEGER)";
    private static final String DROP_MANY_OWNING = "DROP TABLE manyowning";

    @Override
    public void createEntityTable() throws SQLException {
        this.createTable(_createEntity, _dropEntity);
        this.createTable(CREATE_ONE_TO_ONE_A, DROP_ONE_TO_ONE_A);
        this.createTable(CREATE_ONE_TO_ONE_B, DROP_ONE_TO_ONE_B);
        this.createTable(CREATE_ONE_OWNING, DROP_ONE_OWNING);
        this.createTable(CREATE_ONE_INVERSE, DROP_ONE_INVERSE);
        this.createTable(CREATE_MANY_OWNING, DROP_MANY_OWNING);
    }

    @Override
    public void dropEntityTable() throws SQLException {
        this.dropTable(_dropEntity);
        this.dropTable(DROP_ONE_TO_ONE_A);
        this.dropTable(DROP_ONE_TO_ONE_B);
        this.dropTable(DROP_ONE_OWNING);
        this.dropTable(DROP_ONE_INVERSE);
        this.dropTable(DROP_MANY_OWNING);
    }

    @Override
    public void createAccountTable() throws SQLException {
        this.createTable(_createAccount, _dropAccount);
    }

    @Override
    public void dropAccountTable() throws SQLException {
        this.dropTable(_dropAccount);
    }

    private void createTable(String create, String drop) throws SQLException {
        try {
            try {
                this.database.execute(drop);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.database.execute(create);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Cannot create table: " + re.getMessage(), create);
        }
    }

    private void dropTable(String drop) throws SQLException {
        try {
            this.database.execute(drop);
        }
        catch (RemoteException re) {
            if (re.detail != null && re.detail instanceof SQLException) {
                throw (SQLException)re.detail;
            }
            throw new SQLException("Unable to drop table: " + re.getMessage(), drop);
        }
    }

    @Override
    public void start() throws IllegalStateException {
        try {
            Properties properties = TestManager.getServer().getContextEnvironment();
            this.initialContext = new InitialContext(properties);
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Cannot create initial context: " + e.getClass().getName() + " " + e.getMessage()).initCause(e);
        }
        Object obj = null;
        DatabaseHome databaseHome = null;
        try {
            obj = this.initialContext.lookup("client/tools/DatabaseHome");
            databaseHome = (DatabaseHome)PortableRemoteObject.narrow((Object)obj, DatabaseHome.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find 'client/tools/DatabaseHome': " + e.getClass().getName() + " " + e.getMessage());
        }
        try {
            this.database = databaseHome.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot start database: " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    @Override
    public void stop() throws IllegalStateException {
    }

    @Override
    public void init(Properties props) throws IllegalStateException {
    }

    static {
        System.setProperty("noBanner", "true");
    }
}

