/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.NamedTestCase;
import org.apache.xbean.finder.ClassFinder;

public abstract class TestClient
extends NamedTestCase {
    protected InitialContext initialContext;
    protected EJBMetaData ejbMetaData;
    protected HomeHandle ejbHomeHandle;
    protected Handle ejbHandle;
    protected Integer ejbPrimaryKey;

    public TestClient(String name) {
        super(name);
    }

    @Override
    protected abstract void setUp() throws Exception;

    protected Object cast(Object object, Class type) {
        return PortableRemoteObject.narrow((Object)object, (Class)type);
    }

    protected final void processFieldInjections() {
        Object home = null;
        ClassFinder finder = null;
        List fieldList = null;
        finder = new ClassFinder(this.getClassPath());
        fieldList = finder.findAnnotatedFields(EJB.class);
        for (Field field : fieldList) {
            EJB ejbAnnotation = field.getAnnotation(EJB.class);
            if (ejbAnnotation.name() == null || ejbAnnotation.name() == "" || ejbAnnotation.beanInterface() == null) continue;
            try {
                home = this.initialContext.lookup(ejbAnnotation.name());
                home = this.cast(home, ejbAnnotation.beanInterface());
                field.setAccessible(true);
                field.set((Object)this, home);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected final void processSetterInjections() {
        Object home = null;
        ClassFinder finder = null;
        List methodList = null;
        finder = new ClassFinder(this.getClassPath());
        methodList = finder.findAnnotatedMethods(EJB.class);
        for (Method method : methodList) {
            EJB ejbAnnotation = method.getAnnotation(EJB.class);
            if (ejbAnnotation.name() == null || ejbAnnotation.name() == "" || ejbAnnotation.beanInterface() == null) continue;
            try {
                home = this.initialContext.lookup(ejbAnnotation.name());
                home = this.cast(home, ejbAnnotation.beanInterface());
                method.setAccessible(true);
                method.invoke((Object)this, home);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private List<Class<?>> getClassPath() {
        Class<?> superClass = null;
        ArrayList classPath = new ArrayList();
        classPath.add(((Object)((Object)this)).getClass());
        superClass = ((Object)((Object)this)).getClass().getSuperclass();
        while (!superClass.equals(Object.class)) {
            classPath.add(superClass);
            superClass = superClass.getSuperclass();
        }
        return classPath;
    }
}

