/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.entity.cmp.UnknownCmpHome;
import org.apache.openejb.test.entity.cmp.UnknownCmpTestClient;

public class UnknownRemoteIntfcTests
extends UnknownCmpTestClient {
    public UnknownRemoteIntfcTests() {
        super("RemoteIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/UnknownCmpHome");
        this.ejbHome = (UnknownCmpHome)PortableRemoteObject.narrow((Object)obj, UnknownCmpHome.class);
        this.ejbObject = this.ejbHome.createObject("Forth Bean");
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            UnknownRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            UnknownRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            UnknownRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        UnknownRemoteIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbObject.businessMethod("sseccuS");
            UnknownRemoteIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            UnknownRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbObject.throwSystemException_NullPointer();
        }
        catch (RemoteException e) {
            Throwable n = e.detail;
            UnknownRemoteIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            UnknownRemoteIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            UnknownRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        UnknownRemoteIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void BUG_test05_invokeAfterSystemException() {
        try {
            this.ejbObject.businessMethod("This refernce is invalid");
            UnknownRemoteIntfcTests.fail((String)"A java.rmi.NoSuchObjectException should have been thrown.");
        }
        catch (NoSuchObjectException e) {
        }
        catch (Throwable e) {
            UnknownRemoteIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

