/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.MarshalledObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.entity.cmp.BasicCmpHome;
import org.apache.openejb.test.entity.cmp2.BasicCmp2TestClient;

public class Cmp2HandleTests
extends BasicCmp2TestClient {
    public Cmp2HandleTests() {
        super("Handle.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp2/BasicCmpHome");
        this.ejbHome = (BasicCmpHome)PortableRemoteObject.narrow((Object)obj, BasicCmpHome.class);
        this.ejbObject = this.ejbHome.createObject("Fifth Bean");
        this.ejbHandle = this.ejbObject.getHandle();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getEJBObject() {
        try {
            EJBObject object = this.ejbHandle.getEJBObject();
            Cmp2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
        }
        catch (Exception e) {
            Cmp2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void Xtest02_copyHandleByMarshalledObject() {
        try {
            MarshalledObject<Handle> obj = new MarshalledObject<Handle>(this.ejbHandle);
            Handle copy = obj.get();
            EJBObject object = copy.getEJBObject();
            Cmp2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
            Cmp2HandleTests.assertTrue((String)"EJBObjects are not identical", (boolean)object.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Cmp2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void Xtest03_copyHandleBySerialize() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.ejbHandle);
            oos.flush();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Handle copy = (Handle)ois.readObject();
            EJBObject object = copy.getEJBObject();
            Cmp2HandleTests.assertNotNull((String)"The EJBObject is null", (Object)object);
            Cmp2HandleTests.assertTrue((String)"EJBObjects are not identical", (boolean)object.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            Cmp2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test04_EJBHome_remove() {
        try {
            this.ejbHome.remove(this.ejbHandle);
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                Cmp2HandleTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                Cmp2HandleTests.assertTrue((boolean)true);
                this.ejbObject = null;
                return;
            }
        }
        catch (Exception e) {
            Cmp2HandleTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

