/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.entity.cmp2.Cmp2TestClient;
import org.apache.openejb.test.entity.ejbql.QueryDataHome;
import org.apache.openejb.test.entity.ejbql.QueryDataLocal;
import org.apache.openejb.test.entity.ejbql.QueryDataRemote;
import org.apache.openejb.test.entity.ejbql.QueryHome;

public class EjbqlLocalTest
extends Cmp2TestClient {
    private QueryHome queryHome;

    public EjbqlLocalTest() {
        super("EJBQLTest.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/ejbql/Query");
        this.queryHome = (QueryHome)PortableRemoteObject.narrow((Object)obj, QueryHome.class);
        obj = this.initialContext.lookup("client/tests/entity/ejbql/QueryData");
        QueryDataHome queryDataHome = (QueryDataHome)PortableRemoteObject.narrow((Object)obj, QueryDataHome.class);
        queryDataHome.create(0);
        queryDataHome.create(1);
        queryDataHome.create(2);
        queryDataHome.create(3);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSelectSingleStringField() throws Exception {
        String result = this.queryHome.selectSingleStringField("2");
        EjbqlLocalTest.assertEquals((String)"2", (String)result);
    }

    public void testSelectSingleBooleanField() throws Exception {
        boolean result = this.queryHome.selectSingleBooleanField(true);
        EjbqlLocalTest.assertEquals((boolean)true, (boolean)result);
    }

    public void testSelectSingleCharField() throws Exception {
        char result = this.queryHome.selectSingleCharField('2');
        EjbqlLocalTest.assertEquals((char)'2', (char)result);
    }

    public void testSelectSingleByteField() throws Exception {
        byte result = this.queryHome.selectSingleByteField((byte)2);
        EjbqlLocalTest.assertEquals((int)2, (int)result);
    }

    public void testSelectSingleShortField() throws Exception {
        short result = this.queryHome.selectSingleShortField((short)2);
        EjbqlLocalTest.assertEquals((int)2, (int)result);
    }

    public void testSelectSingleIntField() throws Exception {
        int result = this.queryHome.selectSingleIntField(2);
        EjbqlLocalTest.assertEquals((int)2, (int)result);
    }

    public void testSelectSingleLongField() throws Exception {
        long result = this.queryHome.selectSingleLongField(2L);
        EjbqlLocalTest.assertEquals((long)2L, (long)result);
    }

    public void testSelectSingleFloatField() throws Exception {
        float result = this.queryHome.selectSingleFloatField(2.0f);
        EjbqlLocalTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(result));
    }

    public void testSelectSingleDoubleField() throws Exception {
        double result = this.queryHome.selectSingleDoubleField(2.0);
        EjbqlLocalTest.assertEquals((Object)2.0, (Object)result);
    }

    public void testSelectCollectionStringField() throws Exception {
        Collection result = this.queryHome.selectCollectionStringField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, "0", "1", "2", "3");
    }

    public void testSelectCollectionBooleanField() throws Exception {
        Collection result = this.queryHome.selectCollectionBooleanField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, true, false);
    }

    public void testSelectCollectionCharField() throws Exception {
        Collection result = this.queryHome.selectCollectionCharField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'));
    }

    public void testSelectCollectionByteField() throws Exception {
        Collection result = this.queryHome.selectCollectionByteField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, (byte)0, (byte)1, (byte)2, (byte)3);
    }

    public void testSelectCollectionShortField() throws Exception {
        Collection result = this.queryHome.selectCollectionShortField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, (short)0, (short)1, (short)2, (short)3);
    }

    public void testSelectCollectionIntField() throws Exception {
        Collection result = this.queryHome.selectCollectionIntField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, 0, 1, 2, 3);
    }

    public void testSelectCollectionLongField() throws Exception {
        Collection result = this.queryHome.selectCollectionLongField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, 0L, 1L, 2L, 3L);
    }

    public void testSelectCollectionFloatField() throws Exception {
        Collection result = this.queryHome.selectCollectionFloatField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f));
    }

    public void testSelectCollectionDoubleField() throws Exception {
        Collection result = this.queryHome.selectCollectionDoubleField();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        EjbqlLocalTest.assertCollection(result, 0.0, 1.0, 2.0, 3.0);
    }

    public void testSelectSingleLocalEjb() throws Exception {
        Object result = this.queryHome.selectSingleLocalEjb(2);
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertTrue((String)"result should be an instance of QueryDataLocal", (boolean)(result instanceof QueryDataLocal));
        QueryDataLocal queryData = (QueryDataLocal)result;
        EjbqlLocalTest.assertEquals((int)2, (int)queryData.getIntField());
    }

    public void testSelectSingleRemoteEjb() throws Exception {
        Object result = this.queryHome.selectSingleRemoteEjb(2);
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertTrue((String)"result should be an instance of QueryDataRemote", (boolean)(result instanceof QueryDataRemote));
        QueryDataRemote queryData = (QueryDataRemote)result;
        EjbqlLocalTest.assertEquals((int)2, (int)queryData.getIntField());
    }

    public void testSelectCollectionLocalEjb() throws Exception {
        Collection result = this.queryHome.selectCollectionLocalEjb();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Object object : result) {
            EjbqlLocalTest.assertTrue((String)("result item should be an instance of QueryDataLocal but is instance of " + Arrays.toString(object.getClass().getInterfaces())), (boolean)(object instanceof QueryDataLocal));
            QueryDataLocal queryData = (QueryDataLocal)object;
            values.add(queryData.getIntField());
        }
        EjbqlLocalTest.assertCollection(values, 0, 1, 2, 3);
    }

    public void testSelectCollectionRemoteEjb() throws Exception {
        Collection result = this.queryHome.selectCollectionRemoteEjb();
        EjbqlLocalTest.assertNotNull((String)"result is null", (Object)result);
        EjbqlLocalTest.assertEquals((String)"result.size()", (int)4, (int)result.size());
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Object object : result) {
            EjbqlLocalTest.assertTrue((String)"result item should be an instance of QueryDataRemote", (boolean)(object instanceof QueryDataRemote));
            QueryDataRemote queryData = (QueryDataRemote)object;
            values.add(queryData.getIntField());
        }
        EjbqlLocalTest.assertCollection(values, 0, 1, 2, 3);
    }

    private static <E> void assertCollection(Collection collection, E ... values) {
        EjbqlLocalTest.assertEquals(new TreeSet<E>(Arrays.asList(values)), new TreeSet(collection));
    }
}

