/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.mdb.InterceptorMdbObject;
import org.apache.openejb.test.mdb.MdbProxy;
import org.apache.openejb.test.mdb.MdbTestClient;

public class MdbInterceptorTests
extends MdbTestClient {
    protected InterceptorMdbObject ejbObject;

    public MdbInterceptorTests() {
        super("MDBInterceptor.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Destination destination = (Destination)this.initialContext.lookup("InterceptorMdbBean");
        this.ejbObject = (InterceptorMdbObject)MdbProxy.newProxyInstance(InterceptorMdbObject.class, (ConnectionFactory)this.connectionFactory, (Destination)destination);
        TestManager.getDatabase().createEntityTable();
    }

    @Override
    protected void tearDown() throws Exception {
        MdbProxy.destroyProxy((Object)this.ejbObject);
        try {
            TestManager.getDatabase().dropEntityTable();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_checkClassLevelBusinessMethodInterception() {
        try {
            this.ejbObject.checkClassLevelBusinessMethodInterception();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            MdbInterceptorTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_checkMethodLevelBusinessMethodInterception() {
        try {
            this.ejbObject.checkMethodLevelBusinessMethodInterception();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            MdbInterceptorTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_checkClassLevelCreateMethodInterception() {
        try {
            this.ejbObject.checkClassLevelCreateMethodInterception();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            MdbInterceptorTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_checkMethodLevelCreateMethodInterception() {
        try {
            this.ejbObject.checkMethodLevelCreateMethodInterception();
        }
        catch (TestFailureException e) {
            throw e.error;
        }
        catch (Exception e) {
            MdbInterceptorTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

