/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.entity.bmp.EncBmpHome;
import org.apache.openejb.test.entity.bmp.EncBmpObject;
import org.apache.openejb.test.entity.cmp.EncCmpHome;
import org.apache.openejb.test.entity.cmp.EncCmpObject;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;
import org.apache.openejb.test.singleton.EncSingletonHome;
import org.apache.openejb.test.singleton.EncSingletonObject;
import org.apache.openejb.test.stateful.EncStatefulHome;
import org.apache.openejb.test.stateful.EncStatefulObject;

public class MiscEjbTests
extends BasicSingletonTestClient {
    public MiscEjbTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonHome");
        this.ejbHome = (BasicSingletonHome)PortableRemoteObject.narrow((Object)obj, BasicSingletonHome.class);
        this.ejbObject = this.ejbHome.createObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_isIdentical_singleton() {
        try {
            String jndiName = "client/tests/singleton/EncBean";
            EncSingletonHome ejbHome2 = null;
            EncSingletonObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncSingletonHome)PortableRemoteObject.narrow((Object)obj, EncSingletonHome.class);
            ejbObject2 = ejbHome2.create();
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical_stateful() {
        try {
            String jndiName = "client/tests/stateful/EncBean";
            EncStatefulHome ejbHome2 = null;
            EncStatefulObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical_bmp() {
        try {
            String jndiName = "client/tests/entity/bmp/EncBean";
            EncBmpHome ejbHome2 = null;
            EncBmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncBmpHome)PortableRemoteObject.narrow((Object)obj, EncBmpHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_isIdentical_cmp() {
        try {
            String jndiName = "client/tests/entity/cmp/EncBean";
            EncCmpHome ejbHome2 = null;
            EncCmpObject ejbObject2 = null;
            Object obj = this.initialContext.lookup(jndiName);
            ejbHome2 = (EncCmpHome)PortableRemoteObject.narrow((Object)obj, EncCmpHome.class);
            ejbObject2 = ejbHome2.create("isIdentical test");
            MiscEjbTests.assertTrue((String)"The EJBObjects should not be identical", (!this.ejbObject.isIdentical((EJBObject)ejbObject2) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            MiscEjbTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

