/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.beans.TimerSync;
import org.apache.openejb.test.object.OperationsPolicy;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class SingletonAllowedOperationsTests
extends BasicSingletonTestClient {
    protected TimerSync timerSync;

    public SingletonAllowedOperationsTests() {
        super("AllowedOperations.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonHome");
        this.ejbHome = (BasicSingletonHome)PortableRemoteObject.narrow((Object)obj, BasicSingletonHome.class);
        this.ejbObject = this.ejbHome.createObject();
        this.ejbHandle = this.ejbObject.getHandle();
        this.timerSync = (TimerSync)this.initialContext.lookup("TimerSyncBeanBusinessRemote");
        this.ejbObject.businessMethod("activate me please");
    }

    private void setUp_ejbActivate_Passivate() throws Exception {
        EJBObject[] ejbObjects = new EJBObject[10];
        for (int i = 0; i < ejbObjects.length; ++i) {
            ejbObjects[i] = this.ejbHome.createObject();
        }
        this.ejbObject.businessMethod("activate me please");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.ejbObject.remove();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.tearDown();
        }
    }

    public void test01_setSessionContext() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("setSessionContext");
            SingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            SingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_ejbCreate() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbCreate");
            SingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            SingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void TODO_test03_ejbRemove() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbRemove");
            SingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            SingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_businessMethod() {
        try {
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(4);
            policy.allow(2);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("businessMethod");
            SingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            SingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test05_ejbTimeout() {
        try {
            this.ejbObject.scheduleTimer("SingletonAllowedOperationsTests");
            this.timerSync.waitFor("SingletonAllowedOperationsTests");
            OperationsPolicy policy = new OperationsPolicy();
            policy.allow(0);
            policy.allow(1);
            policy.allow(3);
            policy.allow(4);
            policy.allow(2);
            policy.allow(6);
            policy.allow(12);
            policy.allow(11);
            policy.allow(8);
            OperationsPolicy expected = policy;
            OperationsPolicy actual = this.ejbObject.getAllowedOperationsReport("ejbTimeout");
            SingletonAllowedOperationsTests.assertNotNull((String)"The OperationsPolicy is null", (Object)actual);
            SingletonAllowedOperationsTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            SingletonAllowedOperationsTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

