/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import javax.ejb.EJBHome;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonObject;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class SingletonPojoEjbMetaDataTests
extends BasicSingletonTestClient {
    public SingletonPojoEjbMetaDataTests() {
        super("PojoEjbMetaData");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonPojoHome");
        this.ejbHome = (BasicSingletonHome)PortableRemoteObject.narrow((Object)obj, BasicSingletonHome.class);
        this.ejbMetaData = this.ejbHome.getEJBMetaData();
    }

    public void test01_getEJBHome() {
        try {
            EJBHome home = this.ejbMetaData.getEJBHome();
            SingletonPojoEjbMetaDataTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getHomeInterfaceClass() {
        try {
            Class clazz = this.ejbMetaData.getHomeInterfaceClass();
            SingletonPojoEjbMetaDataTests.assertNotNull((String)"The Home Interface class is null", (Object)clazz);
            SingletonPojoEjbMetaDataTests.assertEquals((Object)clazz, BasicSingletonHome.class);
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getPrimaryKeyClass() {
        try {
            Class clazz = this.ejbMetaData.getPrimaryKeyClass();
            SingletonPojoEjbMetaDataTests.assertNull((String)"Should not return a primary key.  Method should throw an java.lang.RuntimeException", (Object)clazz);
        }
        catch (UnsupportedOperationException e) {
            SingletonPojoEjbMetaDataTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonPojoEjbMetaDataTests.assertTrue((String)"Method should throw an java.lang.RuntimeException", (boolean)false);
    }

    public void test04_getRemoteInterfaceClass() {
        try {
            Class clazz = this.ejbMetaData.getRemoteInterfaceClass();
            SingletonPojoEjbMetaDataTests.assertNotNull((String)"The Remote Interface class is null", (Object)clazz);
            SingletonPojoEjbMetaDataTests.assertEquals((Object)clazz, BasicSingletonObject.class);
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_isSession() {
        try {
            SingletonPojoEjbMetaDataTests.assertTrue((String)"EJBMetaData says this is not a session bean", (boolean)this.ejbMetaData.isSession());
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_isSingletonSession() {
        try {
            SingletonPojoEjbMetaDataTests.assertTrue((String)"EJBMetaData says this is not a singleton session bean", (!this.ejbMetaData.isStatelessSession() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            SingletonPojoEjbMetaDataTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

