/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import java.util.ArrayList;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.stateful.BasicStatefulInterceptedRemote;
import org.apache.openejb.test.stateful.BasicStatefulLocalTestClient;

public class StatefulInterceptorTests
extends BasicStatefulLocalTestClient {
    private BasicStatefulInterceptedRemote remoteInterceptor;

    public StatefulInterceptorTests() {
        super("BasicStatefulIntercepted.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("BasicStatefulInterceptedBusinessRemote");
        StatefulInterceptorTests.assertNotNull((String)"The object is null", (Object)obj);
        this.remoteInterceptor = (BasicStatefulInterceptedRemote)PortableRemoteObject.narrow((Object)obj, BasicStatefulInterceptedRemote.class);
        StatefulInterceptorTests.assertNotNull((String)"Remote interceptor is null", (Object)this.remoteInterceptor);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_interceptorChaining() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse(reverseMe);
        StatefulInterceptorTests.assertEquals((String)"tpecretnI", (String)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatefulInterceptorTests.assertNotNull((Object)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatefulInterceptorTests.assertEquals((Object)"superClassInterceptor", interceptorsList.get(0));
        StatefulInterceptorTests.assertEquals((Object)"classInterceptor", interceptorsList.get(1));
        StatefulInterceptorTests.assertEquals((Object)"secondClassInterceptor", interceptorsList.get(2));
        StatefulInterceptorTests.assertEquals((Object)"methodInterceptor", interceptorsList.get(3));
        StatefulInterceptorTests.assertEquals((Object)"ddInterceptor", interceptorsList.get(4));
        StatefulInterceptorTests.assertEquals((Object)"superBeanInterceptor", interceptorsList.get(5));
        StatefulInterceptorTests.assertEquals((Object)"inBeanInterceptor", interceptorsList.get(6));
    }

    public void test02_methodProfile() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse(reverseMe);
        StatefulInterceptorTests.assertEquals((String)"tpecretnI", (String)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatefulInterceptorTests.assertTrue((boolean)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        Object[] params = (Object[])innerMap.get("PARAMETERS");
        StatefulInterceptorTests.assertNotNull((String)"value of PARAMETERS key is null", (Object)params);
        StatefulInterceptorTests.assertEquals((int)1, (int)params.length);
        StatefulInterceptorTests.assertEquals((String)reverseMe, (String)params[0].toString());
    }

    public void test03_excludeClassInterceptors() {
        Map contextData = this.remoteInterceptor.getContextData();
        StatefulInterceptorTests.assertNotNull((Object)contextData.containsKey("getContextData"));
        Map innerMap = (Map)contextData.get("getContextData");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatefulInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by superClassInterceptor()", (boolean)interceptorsList.contains("superClassInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
    }

    public void test04_excludeClassInterceptors_02() {
        String catString = this.remoteInterceptor.concat("Inter", "cept");
        StatefulInterceptorTests.assertEquals((String)"Intercept", (String)catString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatefulInterceptorTests.assertNotNull((Object)contextData.containsKey("concat"));
        Map innerMap = (Map)contextData.get("concat");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatefulInterceptorTests.assertFalse((String)"concat() should not have been intercepted by superClassInterceptor()", (boolean)interceptorsList.contains("superClassInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"concat() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"concat() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
        StatefulInterceptorTests.assertFalse((String)"concat() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
    }

    public void test05_PreDestroy() {
        try {
            this.tearDown();
            Map contextData = this.remoteInterceptor.getContextData();
            Map innerMap = (Map)contextData.get("BasicStatefulInterceptedBean");
            StatefulInterceptorTests.assertNotNull((String)"InnerMap is null", (Object)innerMap);
            ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
            StatefulInterceptorTests.assertEquals((Object)"superClassInterceptorPreDestroy", interceptorsList.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

