/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.StatefulTestClient;

public class StatefulRemoteBusinessIntfcTests
extends StatefulTestClient {
    private BasicStatefulBusinessRemote businessRemote;

    public StatefulRemoteBusinessIntfcTests() {
        super("RemoteBusinessIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test00_lookupBusinessInterface() throws Exception {
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulPojoHomeBusinessRemote");
        StatefulRemoteBusinessIntfcTests.assertNotNull((Object)obj);
        StatefulRemoteBusinessIntfcTests.assertTrue((String)"instance of BasicStatefulBusinessRemote", (boolean)(obj instanceof BasicStatefulBusinessRemote));
        this.businessRemote = (BasicStatefulBusinessRemote)obj;
    }

    public void test01_businessMethod() {
        Object actual;
        Object expected;
        try {
            expected = "Success";
            actual = this.businessRemote.businessMethod("sseccuS");
            StatefulRemoteBusinessIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatefulRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        try {
            expected = new Integer(42);
            actual = this.businessRemote.echo(expected);
            StatefulRemoteBusinessIntfcTests.assertEquals((Object)expected, (Object)actual);
            StatefulRemoteBusinessIntfcTests.assertNotSame((String)"pass by value", (Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.businessRemote.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatefulRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulRemoteBusinessIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.businessRemote.businessMethod("sseccuS");
            StatefulRemoteBusinessIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            StatefulRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void _test04_throwSystemException() {
        try {
            this.businessRemote.throwSystemException_NullPointer();
        }
        catch (Exception e) {
            Throwable n = e.getCause();
            StatefulRemoteBusinessIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)n);
            StatefulRemoteBusinessIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + n.getClass().getName()), (boolean)(n instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatefulRemoteBusinessIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulRemoteBusinessIntfcTests.fail((String)"A NullPointerException should have been thrown.");
    }

    public void TODO_test05_invokeAfterSystemException() {
    }

    public void test06_testRemove() {
        Object obj = this.businessRemote.remove();
        StatefulRemoteBusinessIntfcTests.assertNotNull((Object)obj);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

