/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.object.ObjectGraph;
import org.apache.openejb.test.stateful.EncStatefulHome;
import org.apache.openejb.test.stateful.EncStatefulObject;
import org.apache.openejb.test.stateful.RmiIiopStatefulHome;
import org.apache.openejb.test.stateful.RmiIiopStatefulObject;
import org.apache.openejb.test.stateful.StatefulTestClient;

public class StatefulRmiIiopTests
extends StatefulTestClient {
    protected RmiIiopStatefulHome ejbHome;
    protected RmiIiopStatefulObject ejbObject;

    public StatefulRmiIiopTests() {
        super("RMI_IIOP.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/RMI-over-IIOP/EJBHome");
        this.ejbHome = (RmiIiopStatefulHome)PortableRemoteObject.narrow((Object)obj, RmiIiopStatefulHome.class);
        this.ejbObject = this.ejbHome.create("RMI-IIOP TestBean");
    }

    public void test01_returnStringObject() {
        try {
            String expected = new String("1");
            String actual = this.ejbObject.returnStringObject(expected);
            StatefulRmiIiopTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_returnStringObjectArray() {
        try {
            String[] expected = new String[]{"1", "2", "3"};
            String[] actual = this.ejbObject.returnStringObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (String)expected[i], (String)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_returnCharacterObject() {
        try {
            Character expected = new Character('1');
            Character actual = this.ejbObject.returnCharacterObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_returnCharacterPrimitive() {
        try {
            char expected = '1';
            char actual = this.ejbObject.returnCharacterPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((char)expected, (char)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_returnCharacterObjectArray() {
        try {
            Character[] expected = new Character[]{new Character('1'), new Character('2'), new Character('3')};
            Character[] actual = this.ejbObject.returnCharacterObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_returnCharacterPrimitiveArray() {
        try {
            char[] expected = new char[]{'1', '2', '3'};
            char[] actual = this.ejbObject.returnCharacterPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (char)expected[i], (char)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_returnBooleanObject() {
        try {
            Boolean expected = new Boolean(true);
            Boolean actual = this.ejbObject.returnBooleanObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_returnBooleanPrimitive() {
        try {
            boolean expected = true;
            boolean actual = this.ejbObject.returnBooleanPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((String)("" + expected), (String)("" + actual));
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_returnBooleanObjectArray() {
        try {
            Boolean[] expected = new Boolean[]{new Boolean(true), new Boolean(false), new Boolean(true)};
            Boolean[] actual = this.ejbObject.returnBooleanObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_returnBooleanPrimitiveArray() {
        try {
            boolean[] expected = new boolean[]{false, true, true};
            boolean[] actual = this.ejbObject.returnBooleanPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (boolean)expected[i], (boolean)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_returnByteObject() {
        try {
            Byte expected = new Byte("1");
            Byte actual = this.ejbObject.returnByteObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_returnBytePrimitive() {
        try {
            byte expected = 1;
            byte actual = this.ejbObject.returnBytePrimitive(expected);
            StatefulRmiIiopTests.assertEquals((byte)expected, (byte)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test13_returnByteObjectArray() {
        try {
            Byte[] expected = new Byte[]{new Byte("1"), new Byte("2"), new Byte("3")};
            Byte[] actual = this.ejbObject.returnByteObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test14_returnBytePrimitiveArray() {
        try {
            byte[] expected = new byte[]{1, 2, 3};
            byte[] actual = this.ejbObject.returnBytePrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (byte)expected[i], (byte)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test15_returnShortObject() {
        try {
            Short expected = new Short("1");
            Short actual = this.ejbObject.returnShortObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test16_returnShortPrimitive() {
        try {
            short expected = 1;
            short actual = this.ejbObject.returnShortPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((short)expected, (short)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test17_returnShortObjectArray() {
        try {
            Short[] expected = new Short[]{new Short("1"), new Short("2"), new Short("3")};
            Short[] actual = this.ejbObject.returnShortObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test18_returnShortPrimitiveArray() {
        try {
            short[] expected = new short[]{1, 2, 3};
            short[] actual = this.ejbObject.returnShortPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (short)expected[i], (short)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test19_returnIntegerObject() {
        try {
            Integer expected = new Integer(1);
            Integer actual = this.ejbObject.returnIntegerObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test20_returnIntegerPrimitive() {
        try {
            int expected = 1;
            int actual = this.ejbObject.returnIntegerPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((int)expected, (int)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test21_returnIntegerObjectArray() {
        try {
            Integer[] expected = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
            Integer[] actual = this.ejbObject.returnIntegerObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test22_returnIntegerPrimitiveArray() {
        try {
            int[] expected = new int[]{1, 2, 3};
            int[] actual = this.ejbObject.returnIntegerPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (int)expected[i], (int)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test23_returnLongObject() {
        try {
            Long expected = new Long("1");
            Long actual = this.ejbObject.returnLongObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test24_returnLongPrimitive() {
        try {
            long expected = 1L;
            long actual = this.ejbObject.returnLongPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((long)expected, (long)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test25_returnLongObjectArray() {
        try {
            Long[] expected = new Long[]{new Long("1"), new Long("2"), new Long("3")};
            Long[] actual = this.ejbObject.returnLongObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test26_returnLongPrimitiveArray() {
        try {
            long[] expected = new long[]{1L, 2L, 3L};
            long[] actual = this.ejbObject.returnLongPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test27_returnFloatObject() {
        try {
            Float expected = new Float("1.3");
            Float actual = this.ejbObject.returnFloatObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test28_returnFloatPrimitive() {
        try {
            float expected = 1.2f;
            float actual = this.ejbObject.returnFloatPrimitive(expected);
            StatefulRmiIiopTests.assertEquals((double)expected, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test29_returnFloatObjectArray() {
        try {
            Float[] expected = new Float[]{new Float("1.1"), new Float("2.2"), new Float("3.3")};
            Float[] actual = this.ejbObject.returnFloatObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test30_returnFloatPrimitiveArray() {
        try {
            float[] expected = new float[]{1.2f, 2.3f, 3.4f};
            float[] actual = this.ejbObject.returnFloatPrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test31_returnDoubleObject() {
        try {
            Double expected = new Double("1.1");
            Double actual = this.ejbObject.returnDoubleObject(expected);
            StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test32_returnDoublePrimitive() {
        try {
            double expected = 1.2;
            double actual = this.ejbObject.returnDoublePrimitive(expected);
            StatefulRmiIiopTests.assertEquals((double)expected, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test33_returnDoubleObjectArray() {
        try {
            Double[] expected = new Double[]{new Double("1.3"), new Double("2.4"), new Double("3.5")};
            Double[] actual = this.ejbObject.returnDoubleObjectArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test34_returnDoublePrimitiveArray() {
        try {
            double[] expected = new double[]{1.4, 2.5, 3.6};
            double[] actual = this.ejbObject.returnDoublePrimitiveArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test35_returnEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome expected = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            EncStatefulHome actual = (EncStatefulHome)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBHome((EJBHome)expected), EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test36_returnEJBHome2() {
        try {
            EncStatefulHome actual = (EncStatefulHome)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBHome(), EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test37_returnNestedEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome expected = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatefulHome actual = (EncStatefulHome)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test38_returnNestedEJBHome2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBHome();
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatefulHome actual = (EncStatefulHome)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test39_returnEJBHomeArray() {
        try {
            EncStatefulHome[] expected = new EncStatefulHome[3];
            for (int i = 0; i < expected.length; ++i) {
                Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
                expected[i] = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
                StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected[i]);
            }
            EJBHome[] actual = this.ejbObject.returnEJBHomeArray((EJBHome[])expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test40_returnEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject expected = home.create("test_40 StatefulBean");
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            EncStatefulObject actual = (EncStatefulObject)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBObject((EJBObject)expected), EncStatefulObject.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            StatefulRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test41_returnEJBObject2() {
        try {
            EncStatefulObject actual = (EncStatefulObject)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBObject(), EncStatefulObject.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test42_returnNestedEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject expected = home.create("test_42 StatefulBean");
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatefulObject actual = (EncStatefulObject)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatefulObject.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            StatefulRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test43_returnNestedEJBObject2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBObject();
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatefulObject actual = (EncStatefulObject)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatefulObject.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test44_returnEJBObjectArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject[] expected = new EncStatefulObject[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.create("test_44 StatefulBean");
                StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected[i]);
            }
            EJBObject[] actual = this.ejbObject.returnEJBObjectArray((EJBObject[])expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected[i].isIdentical(actual[i]));
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test45_returnEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            EJBMetaData actual = this.ejbObject.returnEJBMetaData(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatefulRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test46_returnEJBMetaData() {
        try {
            EJBMetaData actual = this.ejbObject.returnEJBMetaData();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((Object)actual.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatefulRmiIiopTests.assertEquals((Object)actual.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test47_returnNestedEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatefulRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test48_returnNestedEJBMetaData2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBMetaData();
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatefulRmiIiopTests.assertNotNull((String)"The home interface class of the EJBMetaData is null", (Object)actual.getHomeInterfaceClass());
            StatefulRmiIiopTests.assertNotNull((String)"The remote interface class of the EJBMetaData is null", (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test49_returnEJBMetaDataArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData[] expected = new EJBMetaData[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.getEJBMetaData();
                StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected[i]);
            }
            EJBMetaData[] actual = this.ejbObject.returnEJBMetaDataArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatefulRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual[i]);
                StatefulRmiIiopTests.assertEquals((Object)expected[i].getHomeInterfaceClass(), (Object)actual[i].getHomeInterfaceClass());
                StatefulRmiIiopTests.assertEquals((Object)expected[i].getRemoteInterfaceClass(), (Object)actual[i].getRemoteInterfaceClass());
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test50_returnHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject object = home.create("test_50 StatefulBean");
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            Handle actual = this.ejbObject.returnHandle(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            StatefulRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test51_returnHandle() {
        try {
            Handle actual = this.ejbObject.returnHandle();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test52_returnNestedHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject object = home.create("test_52 StatefulBean");
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            StatefulRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test53_returnNestedHandle2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedHandle();
            StatefulRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test54_returnHandleArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateful/EncBean");
            EncStatefulHome home = (EncStatefulHome)PortableRemoteObject.narrow((Object)obj, EncStatefulHome.class);
            StatefulRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatefulObject object = home.create("test_54 StatefulBean");
            StatefulRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle[] expected = new Handle[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = object.getHandle();
                StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected[i]);
            }
            Handle[] actual = this.ejbObject.returnHandleArray(expected);
            StatefulRmiIiopTests.assertNotNull((String)"The Handle array returned is null", (Object)actual);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatefulRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual[i]);
                StatefulRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual[i].getEJBObject());
                StatefulRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not equal", (boolean)expected[i].getEJBObject().isIdentical(actual[i].getEJBObject()));
            }
        }
        catch (Exception e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test55_returnObjectGraph() {
    }

    public void test56_returnObjectGraphArray() {
    }

    public void test57_returnClass() {
        Class[] primitives;
        for (Class expected : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            try {
                Class actual = this.ejbObject.returnClass(expected);
                StatefulRmiIiopTests.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
    }

    public void test58_returnClassArray() {
        try {
            Class[] expected = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            Class[] actual = this.ejbObject.returnClassArray(expected);
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatefulRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test59_returnClassObjectGraph() {
        try {
            Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            ObjectGraph expectedGraph = new ObjectGraph((Object)primitives);
            ObjectGraph actualGraph = this.ejbObject.returnObjectGraph(expectedGraph);
            Class[] expected = (Class[])expectedGraph.getObject();
            Class[] actual = (Class[])actualGraph.getObject();
            StatefulRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatefulRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            StatefulRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

