/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.util.Properties;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.NamedTestCase;
import org.apache.openejb.test.TestManager;
import org.apache.openejb.test.stateless.ContainerTxStatelessHome;
import org.apache.openejb.test.stateless.ContainerTxStatelessObject;

public class StatelessContainerTxTests
extends NamedTestCase {
    public static final String jndiEJBHomeEntry = "client/tests/stateless/ContainerManagedTransactionTests/EJBHome";
    protected ContainerTxStatelessHome ejbHome;
    protected ContainerTxStatelessObject ejbObject;
    protected EJBMetaData ejbMetaData;
    protected HomeHandle ejbHomeHandle;
    protected Handle ejbHandle;
    protected Integer ejbPrimaryKey;
    protected InitialContext initialContext;

    public StatelessContainerTxTests() {
        super("Stateless.ContainerManagedTransaction.");
    }

    @Override
    protected void setUp() throws Exception {
        Properties properties = TestManager.getServer().getContextEnvironment();
        this.initialContext = new InitialContext(properties);
        Object obj = this.initialContext.lookup(jndiEJBHomeEntry);
        this.ejbHome = (ContainerTxStatelessHome)PortableRemoteObject.narrow((Object)obj, ContainerTxStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
        TestManager.getDatabase().createAccountTable();
    }

    @Override
    protected void tearDown() throws Exception {
        TestManager.getDatabase().dropAccountTable();
    }

    public void test01_txMandatory_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test01_txMandatory_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx_appException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test01_txMandatory_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_txNever_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_txNotSupported_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_txRequired_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_txRequiresNew_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_txSupports_withoutTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_txMandatory_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txMandatoryMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_txNever_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNeverMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_txNotSupported_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txNotSupportedMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_txRequired_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiredMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_txRequiresNew_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txRequiresNewMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_txSupports_withTx_sysException() {
        try {
            String expected = "ping";
            String actual = this.ejbObject.txSupportsMethod(expected);
            StatelessContainerTxTests.assertEquals((String)"The method invocation was invalid.", (String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessContainerTxTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

