/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessTestClient;

public class StatelessEjbObjectTests
extends BasicStatelessTestClient {
    public StatelessEjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessHome");
        this.ejbHome = (BasicStatelessHome)PortableRemoteObject.narrow((Object)obj, BasicStatelessHome.class);
        this.ejbObject = this.ejbHome.createObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            StatelessEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical() {
        try {
            StatelessEjbObjectTests.assertTrue((String)"The EJBObjects are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            StatelessEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getPrimaryKey() {
        try {
            Object key = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            StatelessEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            this.ejbObject.businessMethod("Should not throw an exception");
        }
        catch (Exception e) {
            StatelessEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_remove() {
        String str = null;
        try {
            str = this.ejbObject.remove("Hello");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        StatelessEjbObjectTests.assertEquals((String)"Hello", (String)str);
    }
}

