/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.util.ArrayList;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.stateless.BasicStatelessInterceptedRemote;
import org.apache.openejb.test.stateless.BasicStatelessLocalTestClient;

public class StatelessInterceptorTests
extends BasicStatelessLocalTestClient {
    private BasicStatelessInterceptedRemote remoteInterceptor;

    public StatelessInterceptorTests() {
        super("BasicStatelessIntercepted.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("BasicStatelessInterceptedBusinessRemote");
        StatelessInterceptorTests.assertNotNull((String)"The BasicStatelessInterceptedBusinessRemote object is null", (Object)obj);
        this.remoteInterceptor = (BasicStatelessInterceptedRemote)PortableRemoteObject.narrow((Object)obj, BasicStatelessInterceptedRemote.class);
        StatelessInterceptorTests.assertNotNull((String)"Remote interceptor is null", (Object)this.remoteInterceptor);
    }

    public void test01_interceptorChaining() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse(reverseMe);
        StatelessInterceptorTests.assertEquals((String)"tpecretnI", (String)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatelessInterceptorTests.assertNotNull((Object)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatelessInterceptorTests.assertEquals((Object)"ddInterceptor", interceptorsList.get(0));
        StatelessInterceptorTests.assertEquals((Object)"secondClassInterceptor", interceptorsList.get(1));
        StatelessInterceptorTests.assertEquals((Object)"superClassInterceptor", interceptorsList.get(2));
        StatelessInterceptorTests.assertEquals((Object)"classInterceptor", interceptorsList.get(3));
        StatelessInterceptorTests.assertEquals((Object)"methodInterceptor", interceptorsList.get(4));
        StatelessInterceptorTests.assertEquals((Object)"superBeanInterceptor", interceptorsList.get(5));
        StatelessInterceptorTests.assertEquals((Object)"inBeanInterceptor", interceptorsList.get(6));
    }

    public void test02_methodProfile() {
        String reverseMe = "Intercept";
        String reversedString = this.remoteInterceptor.reverse(reverseMe);
        StatelessInterceptorTests.assertEquals((String)"tpecretnI", (String)reversedString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatelessInterceptorTests.assertTrue((boolean)contextData.containsKey("reverse"));
        Map innerMap = (Map)contextData.get("reverse");
        Object[] params = (Object[])innerMap.get("PARAMETERS");
        StatelessInterceptorTests.assertNotNull((String)"value of PARAMETERS key is null", (Object)params);
        StatelessInterceptorTests.assertEquals((int)1, (int)params.length);
        StatelessInterceptorTests.assertEquals((String)reverseMe, (String)params[0].toString());
    }

    public void test03_excludeClassInterceptors() {
        Map contextData = this.remoteInterceptor.getContextData();
        StatelessInterceptorTests.assertNotNull((Object)contextData.containsKey("getContextData"));
        Map innerMap = (Map)contextData.get("getContextData");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatelessInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"getContextData() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
    }

    public void test04_excludeClassInterceptors_02() {
        String catString = this.remoteInterceptor.concat("Inter", "cept");
        StatelessInterceptorTests.assertEquals((String)"Intercept", (String)catString);
        Map contextData = this.remoteInterceptor.getContextData();
        StatelessInterceptorTests.assertNotNull((Object)contextData.containsKey("concat"));
        Map innerMap = (Map)contextData.get("concat");
        ArrayList interceptorsList = (ArrayList)innerMap.get("INTERCEPTORS");
        StatelessInterceptorTests.assertFalse((String)"concat() should not have been intercepted by superClassInterceptor()", (boolean)interceptorsList.contains("superClassInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"concat() should not have been intercepted by classInterceptor()", (boolean)interceptorsList.contains("classInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"concat() should not have been intercepted by ddInterceptor()", (boolean)interceptorsList.contains("ddInterceptor"));
        StatelessInterceptorTests.assertFalse((String)"concat() should not have been intercepted by secondClassInterceptor()", (boolean)interceptorsList.contains("secondClassInterceptor"));
    }
}

