/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import javax.ejb.EJBException;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.stateless.BasicStatelessLocalHome;
import org.apache.openejb.test.stateless.BasicStatelessLocalTestClient;

public class StatelessLocalIntfcTests
extends BasicStatelessLocalTestClient {
    public StatelessLocalIntfcTests() {
        super("LocalIntfc.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/BasicStatelessPojoHomeLocal");
        this.ejbLocalHome = (BasicStatelessLocalHome)obj;
        this.ejbLocalObject = this.ejbLocalHome.create();
    }

    public void test01_businessMethod() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            StatelessLocalIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessLocalIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_throwApplicationException() {
        try {
            this.ejbLocalObject.throwApplicationException();
        }
        catch (ApplicationException e) {
            return;
        }
        catch (Throwable e) {
            StatelessLocalIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessLocalIntfcTests.fail((String)"An ApplicationException should have been thrown.");
    }

    public void test03_invokeAfterApplicationException() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            StatelessLocalIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Throwable e) {
            StatelessLocalIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_throwSystemException() {
        try {
            this.ejbLocalObject.throwSystemException_NullPointer();
        }
        catch (EJBException e) {
            StatelessLocalIntfcTests.assertNotNull((String)"Nested exception should not be is null", (Object)((Object)e));
            StatelessLocalIntfcTests.assertTrue((String)("Nested exception should be an instance of NullPointerException, but exception is " + e.getCausedByException().getClass().getName()), (boolean)(e.getCausedByException() instanceof NullPointerException));
            return;
        }
        catch (Throwable e) {
            StatelessLocalIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatelessLocalIntfcTests.fail((String)"An EJBException encapsulating a NullPointerException should have been thrown.");
    }

    public void test05_invokeAfterSystemException() {
        try {
            String expected = "Success";
            String actual = this.ejbLocalObject.businessMethod("sseccuS");
            StatelessLocalIntfcTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessLocalIntfcTests.fail((String)"The business method should have been executed.");
        }
        catch (Throwable e) {
            StatelessLocalIntfcTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

