/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.rmi.PortableRemoteObject;
import org.apache.openejb.test.object.Color;
import org.apache.openejb.test.object.ObjectGraph;
import org.apache.openejb.test.stateless.EncStatelessHome;
import org.apache.openejb.test.stateless.EncStatelessObject;
import org.apache.openejb.test.stateless.RmiIiopStatelessHome;
import org.apache.openejb.test.stateless.RmiIiopStatelessObject;
import org.apache.openejb.test.stateless.StatelessTestClient;

public class StatelessRmiIiopTests
extends StatelessTestClient {
    protected RmiIiopStatelessHome ejbHome;
    protected RmiIiopStatelessObject ejbObject;

    public StatelessRmiIiopTests() {
        super("RMI_IIOP.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateless/RMI-over-IIOP/EJBHome");
        this.ejbHome = (RmiIiopStatelessHome)PortableRemoteObject.narrow((Object)obj, RmiIiopStatelessHome.class);
        this.ejbObject = this.ejbHome.create();
    }

    public void test01_returnStringObject() {
        try {
            String expected = new String("1");
            String actual = this.ejbObject.returnStringObject(expected);
            StatelessRmiIiopTests.assertEquals((String)expected, (String)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_returnStringObjectArray() {
        try {
            String[] expected = new String[]{"1", "2", "3"};
            String[] actual = this.ejbObject.returnStringObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (String)expected[i], (String)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_returnCharacterObject() {
        try {
            Character expected = new Character('1');
            Character actual = this.ejbObject.returnCharacterObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_returnCharacterPrimitive() {
        try {
            char expected = '1';
            char actual = this.ejbObject.returnCharacterPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((char)expected, (char)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_returnCharacterObjectArray() {
        try {
            Character[] expected = new Character[]{new Character('1'), new Character('2'), new Character('3')};
            Character[] actual = this.ejbObject.returnCharacterObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_returnCharacterPrimitiveArray() {
        try {
            char[] expected = new char[]{'1', '2', '3'};
            char[] actual = this.ejbObject.returnCharacterPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (char)expected[i], (char)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test07_returnBooleanObject() {
        try {
            Boolean expected = new Boolean(true);
            Boolean actual = this.ejbObject.returnBooleanObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test08_returnBooleanPrimitive() {
        try {
            boolean expected = true;
            boolean actual = this.ejbObject.returnBooleanPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((String)("" + expected), (String)("" + actual));
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test09_returnBooleanObjectArray() {
        try {
            Boolean[] expected = new Boolean[]{new Boolean(true), new Boolean(false), new Boolean(true)};
            Boolean[] actual = this.ejbObject.returnBooleanObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test10_returnBooleanPrimitiveArray() {
        try {
            boolean[] expected = new boolean[]{false, true, true};
            boolean[] actual = this.ejbObject.returnBooleanPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (boolean)expected[i], (boolean)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test11_returnByteObject() {
        try {
            Byte expected = new Byte("1");
            Byte actual = this.ejbObject.returnByteObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test12_returnBytePrimitive() {
        try {
            byte expected = 1;
            byte actual = this.ejbObject.returnBytePrimitive(expected);
            StatelessRmiIiopTests.assertEquals((byte)expected, (byte)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test13_returnByteObjectArray() {
        try {
            Byte[] expected = new Byte[]{new Byte("1"), new Byte("2"), new Byte("3")};
            Byte[] actual = this.ejbObject.returnByteObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test14_returnBytePrimitiveArray() {
        try {
            byte[] expected = new byte[]{1, 2, 3};
            byte[] actual = this.ejbObject.returnBytePrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (byte)expected[i], (byte)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test15_returnShortObject() {
        try {
            Short expected = new Short("1");
            Short actual = this.ejbObject.returnShortObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test16_returnShortPrimitive() {
        try {
            short expected = 1;
            short actual = this.ejbObject.returnShortPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((short)expected, (short)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test17_returnShortObjectArray() {
        try {
            Short[] expected = new Short[]{new Short("1"), new Short("2"), new Short("3")};
            Short[] actual = this.ejbObject.returnShortObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test18_returnShortPrimitiveArray() {
        try {
            short[] expected = new short[]{1, 2, 3};
            short[] actual = this.ejbObject.returnShortPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (short)expected[i], (short)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test19_returnIntegerObject() {
        try {
            Integer expected = new Integer(1);
            Integer actual = this.ejbObject.returnIntegerObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test20_returnIntegerPrimitive() {
        try {
            int expected = 1;
            int actual = this.ejbObject.returnIntegerPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((int)expected, (int)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test21_returnIntegerObjectArray() {
        try {
            Integer[] expected = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
            Integer[] actual = this.ejbObject.returnIntegerObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test22_returnIntegerPrimitiveArray() {
        try {
            int[] expected = new int[]{1, 2, 3};
            int[] actual = this.ejbObject.returnIntegerPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (int)expected[i], (int)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test23_returnLongObject() {
        try {
            Long expected = new Long("1");
            Long actual = this.ejbObject.returnLongObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test24_returnLongPrimitive() {
        try {
            long expected = 1L;
            long actual = this.ejbObject.returnLongPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((long)expected, (long)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test25_returnLongObjectArray() {
        try {
            Long[] expected = new Long[]{new Long("1"), new Long("2"), new Long("3")};
            Long[] actual = this.ejbObject.returnLongObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test26_returnLongPrimitiveArray() {
        try {
            long[] expected = new long[]{1L, 2L, 3L};
            long[] actual = this.ejbObject.returnLongPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (long)expected[i], (long)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test27_returnFloatObject() {
        try {
            Float expected = new Float("1.3");
            Float actual = this.ejbObject.returnFloatObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test28_returnFloatPrimitive() {
        try {
            float expected = 1.2f;
            float actual = this.ejbObject.returnFloatPrimitive(expected);
            StatelessRmiIiopTests.assertEquals((double)expected, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test29_returnFloatObjectArray() {
        try {
            Float[] expected = new Float[]{new Float("1.1"), new Float("2.2"), new Float("3.3")};
            Float[] actual = this.ejbObject.returnFloatObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test30_returnFloatPrimitiveArray() {
        try {
            float[] expected = new float[]{1.2f, 2.3f, 3.4f};
            float[] actual = this.ejbObject.returnFloatPrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test31_returnDoubleObject() {
        try {
            Double expected = new Double("1.1");
            Double actual = this.ejbObject.returnDoubleObject(expected);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test32_returnDoublePrimitive() {
        try {
            double expected = 1.2;
            double actual = this.ejbObject.returnDoublePrimitive(expected);
            StatelessRmiIiopTests.assertEquals((double)expected, (double)actual, (double)0.0);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test33_returnDoubleObjectArray() {
        try {
            Double[] expected = new Double[]{new Double("1.3"), new Double("2.4"), new Double("3.5")};
            Double[] actual = this.ejbObject.returnDoubleObjectArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test34_returnDoublePrimitiveArray() {
        try {
            double[] expected = new double[]{1.4, 2.5, 3.6};
            double[] actual = this.ejbObject.returnDoublePrimitiveArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertEquals((String)("Array values are not equal at index " + i), (double)expected[i], (double)actual[i], (double)0.0);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test35_returnEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome expected = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            EncStatelessHome actual = (EncStatelessHome)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBHome((EJBHome)expected), EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test36_returnEJBHome2() {
        try {
            EncStatelessHome actual = (EncStatelessHome)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBHome(), EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test37_returnNestedEJBHome() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome expected = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatelessHome actual = (EncStatelessHome)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test38_returnNestedEJBHome2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBHome();
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatelessHome actual = (EncStatelessHome)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test39_returnEJBHomeArray() {
        try {
            EncStatelessHome[] expected = new EncStatelessHome[3];
            for (int i = 0; i < expected.length; ++i) {
                Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
                expected[i] = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
                StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)expected[i]);
            }
            EJBHome[] actual = this.ejbObject.returnEJBHomeArray((EJBHome[])expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test40_returnEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject expected = home.create();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            EncStatelessObject actual = (EncStatelessObject)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBObject((EJBObject)expected), EncStatelessObject.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            StatelessRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test41_returnEJBObject2() {
        try {
            EncStatelessObject actual = (EncStatelessObject)PortableRemoteObject.narrow((Object)this.ejbObject.returnEJBObject(), EncStatelessObject.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test42_returnNestedEJBObject() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject expected = home.create();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatelessObject actual = (EncStatelessObject)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatelessObject.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject returned is null", (Object)actual);
            StatelessRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected.isIdentical((EJBObject)actual));
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test43_returnNestedEJBObject2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBObject();
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EncStatelessObject actual = (EncStatelessObject)PortableRemoteObject.narrow((Object)graph.getObject(), EncStatelessObject.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned is null", (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test44_returnEJBObjectArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject[] expected = new EncStatelessObject[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.create();
                StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)expected[i]);
            }
            EJBObject[] actual = this.ejbObject.returnEJBObjectArray((EJBObject[])expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertTrue((String)"The EJBObejcts are not identical", (boolean)expected[i].isIdentical(actual[i]));
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test45_returnEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            EJBMetaData actual = this.ejbObject.returnEJBMetaData(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatelessRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test46_returnEJBMetaData() {
        try {
            EJBMetaData actual = this.ejbObject.returnEJBMetaData();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)actual.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatelessRmiIiopTests.assertEquals((Object)actual.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test47_returnNestedEJBMetaData() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData expected = home.getEJBMetaData();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected);
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected.getHomeInterfaceClass(), (Object)actual.getHomeInterfaceClass());
            StatelessRmiIiopTests.assertEquals((Object)expected.getRemoteInterfaceClass(), (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test48_returnNestedEJBMetaData2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedEJBMetaData();
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            EJBMetaData actual = (EJBMetaData)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual);
            StatelessRmiIiopTests.assertNotNull((String)"The home interface class of the EJBMetaData is null", (Object)actual.getHomeInterfaceClass());
            StatelessRmiIiopTests.assertNotNull((String)"The remote interface class of the EJBMetaData is null", (Object)actual.getRemoteInterfaceClass());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test49_returnEJBMetaDataArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EJBMetaData[] expected = new EJBMetaData[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = home.getEJBMetaData();
                StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)expected[i]);
            }
            EJBMetaData[] actual = this.ejbObject.returnEJBMetaDataArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < actual.length; ++i) {
                StatelessRmiIiopTests.assertNotNull((String)"The EJBMetaData returned is null", (Object)actual[i]);
                StatelessRmiIiopTests.assertEquals((Object)expected[i].getHomeInterfaceClass(), (Object)actual[i].getHomeInterfaceClass());
                StatelessRmiIiopTests.assertEquals((Object)expected[i].getRemoteInterfaceClass(), (Object)actual[i].getRemoteInterfaceClass());
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test50_returnHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject object = home.create();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            Handle actual = this.ejbObject.returnHandle(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            StatelessRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test51_returnHandle() {
        try {
            Handle actual = this.ejbObject.returnHandle();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test52_returnNestedHandle() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject object = home.create();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle expected = object.getHandle();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)expected.getEJBObject());
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
            EJBObject exp = expected.getEJBObject();
            EJBObject act = actual.getEJBObject();
            StatelessRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not identical", (boolean)exp.isIdentical(act));
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test53_returnNestedHandle2() {
        try {
            ObjectGraph graph = this.ejbObject.returnNestedHandle();
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Handle actual = (Handle)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual.getEJBObject());
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test54_returnHandleArray() {
        try {
            Object obj = this.initialContext.lookup("client/tests/stateless/EncBean");
            EncStatelessHome home = (EncStatelessHome)PortableRemoteObject.narrow((Object)obj, EncStatelessHome.class);
            StatelessRmiIiopTests.assertNotNull((String)"The EJBHome returned from JNDI is null", (Object)home);
            EncStatelessObject object = home.create();
            StatelessRmiIiopTests.assertNotNull((String)"The EJBObject created is null", (Object)object);
            Handle[] expected = new Handle[3];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = object.getHandle();
                StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)expected[i]);
            }
            Handle[] actual = this.ejbObject.returnHandleArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The Handle array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatelessRmiIiopTests.assertNotNull((String)"The EJBObject Handle returned is null", (Object)actual[i]);
                StatelessRmiIiopTests.assertNotNull((String)"The EJBObject in the Handle is null", (Object)actual[i].getEJBObject());
                StatelessRmiIiopTests.assertTrue((String)"The EJBObjects in the Handles are not equal", (boolean)expected[i].getEJBObject().isIdentical(actual[i].getEJBObject()));
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test55_returnObjectGraph() {
    }

    public void test56_returnObjectGraphArray() {
    }

    public void test57_returnClass() {
        Class[] primitives;
        for (Class expected : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            try {
                Class actual = this.ejbObject.returnClass(expected);
                StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
    }

    public void test58_returnClassArray() {
        try {
            Class[] expected = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            Class[] actual = this.ejbObject.returnClassArray(expected);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatelessRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test59_returnClassObjectGraph() {
        try {
            Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            ObjectGraph expectedGraph = new ObjectGraph((Object)primitives);
            ObjectGraph actualGraph = this.ejbObject.returnObjectGraph(expectedGraph);
            Class[] expected = (Class[])expectedGraph.getObject();
            Class[] actual = (Class[])actualGraph.getObject();
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatelessRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (RemoteException e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test60_returnColor() {
        try {
            Color expected = Color.GREEN;
            Color actual = (Color)PortableRemoteObject.narrow((Object)this.ejbObject.returnColor(expected), Color.class);
            StatelessRmiIiopTests.assertNotNull((String)"The Color returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test61_returnColor2() {
        try {
            Color expected = Color.GREEN;
            Color actual = (Color)PortableRemoteObject.narrow((Object)this.ejbObject.returnColor(), Color.class);
            StatelessRmiIiopTests.assertNotNull((String)"The Color returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test62_returnNestedColor() {
        try {
            Color expected = Color.GREEN;
            ObjectGraph graph = this.ejbObject.returnObjectGraph(new ObjectGraph((Object)expected));
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Color actual = (Color)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The Color returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test63_returnNestedColor2() {
        try {
            Color expected = Color.GREEN;
            ObjectGraph graph = this.ejbObject.returnNestedColor();
            StatelessRmiIiopTests.assertNotNull((String)"The ObjectGraph is null", (Object)graph);
            Color actual = (Color)graph.getObject();
            StatelessRmiIiopTests.assertNotNull((String)"The Color returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test64_returnColorArray() {
        try {
            Color[] expected = new Color[]{Color.GREEN, Color.RED, Color.BLUE};
            Color[] actual = this.ejbObject.returnColorArray(expected);
            StatelessRmiIiopTests.assertNotNull((String)"The Color array returned is null", (Object)actual);
            StatelessRmiIiopTests.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                StatelessRmiIiopTests.assertEquals((Object)expected[i], (Object)actual[i]);
            }
        }
        catch (Exception e) {
            StatelessRmiIiopTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }
}

