/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateless;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.apache.openejb.test.SuperInterceptedBean;
import org.apache.openejb.test.interceptor.ClassInterceptor;
import org.apache.openejb.test.interceptor.Interceptor;
import org.apache.openejb.test.interceptor.MethodInterceptor;
import org.apache.openejb.test.stateless.BasicStatelessInterceptedLocal;
import org.apache.openejb.test.stateless.BasicStatelessInterceptedRemote;

@Stateless(name="StatelessIntercepted")
@Interceptors(value={ClassInterceptor.class})
public class StatelessInterceptedBean
extends SuperInterceptedBean
implements BasicStatelessInterceptedLocal,
BasicStatelessInterceptedRemote {
    private static Map<String, Object> contextData = new LinkedHashMap<String, Object>();

    public String concat(String str1, String str2) {
        return str1.concat(str2);
    }

    @Interceptors(value={MethodInterceptor.class})
    public String reverse(String str) {
        if (str.length() > 0) {
            throw new NullPointerException();
        }
        StringBuffer b = new StringBuffer(str);
        return b.reverse().toString();
    }

    private void setContextData(Map<String, Object> ctxData) {
        contextData.putAll(ctxData);
    }

    @ExcludeDefaultInterceptors
    @ExcludeClassInterceptors
    public Map<String, Object> getContextData() {
        return contextData;
    }

    @AroundInvoke
    public Object inBeanInterceptor(InvocationContext ctx) throws Exception {
        Map ctxData = Interceptor.profile((InvocationContext)ctx, (String)"inBeanInterceptor");
        this.setContextData(ctxData);
        return ctx.proceed();
    }

    @PostConstruct
    public void inBeanInterceptorPostConstruct() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPostConstruct");
        this.setContextData(ctxData);
    }

    @PreDestroy
    public void inBeanInterceptorPreDestroy() throws Exception {
        Map ctxData = Interceptor.profile((SuperInterceptedBean)this, (String)"inBeanInterceptorPreDestroy");
        this.setContextData(ctxData);
    }
}

