/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;

public class EjbServlet
extends HttpServlet {
    @EJB
    private BasicStatelessBusinessLocal statelessBusinessLocal;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out);
        String methodName = request.getParameter("method");
        if (methodName == null) {
            this.testAll(printStream);
        } else {
            try {
                Method method = ((Object)((Object)this)).getClass().getMethod(methodName, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                printStream.println("FAILED");
                e.printStackTrace(printStream);
            }
        }
        printStream.flush();
    }

    public void testAll(PrintStream printStream) {
        for (Method method : EjbServlet.class.getMethods()) {
            if (!method.getName().startsWith("invoke")) continue;
            try {
                method.invoke((Object)this, new Object[0]);
                printStream.println(method.getName() + " PASSED");
            }
            catch (Throwable e) {
                printStream.println(method.getName() + " FAILED");
                e.printStackTrace(printStream);
                printStream.flush();
            }
            printStream.println();
        }
    }

    public void invokeBusinessMethod() {
        Assert.assertEquals((String)"oof", (String)this.statelessBusinessLocal.businessMethod("foo"));
    }
}

