/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.ejb.EJB;
import javax.ejb.EJBAccessException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.apache.openejb.test.servlet.EjbServlet;
import org.apache.openejb.test.servlet.SecureEJBLocal;

public class RunAsServlet
extends HttpServlet {
    @EJB
    private SecureEJBLocal secureEJBLocal;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out);
        String methodName = request.getParameter("method");
        if (methodName == null) {
            this.testAll(request, printStream);
        } else {
            try {
                Method method = ((Object)((Object)this)).getClass().getMethod(methodName, HttpServletRequest.class);
                method.invoke((Object)this, request);
            }
            catch (Throwable e) {
                printStream.println("FAILED");
                e.printStackTrace(printStream);
            }
        }
        printStream.flush();
    }

    public void testAll(HttpServletRequest request, PrintStream printStream) {
        for (Method method : EjbServlet.class.getMethods()) {
            if (!method.getName().startsWith("invoke")) continue;
            try {
                method.invoke((Object)this, new Object[0]);
                printStream.println(method.getName() + " PASSED");
            }
            catch (Throwable e) {
                printStream.println(method.getName() + " FAILED");
                e.printStackTrace(printStream);
                printStream.flush();
            }
            printStream.println();
        }
    }

    public void invokeGetCallerPrincipal(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((String)"user", (String)principal.getName());
        principal = this.secureEJBLocal.getCallerPrincipal();
        Assert.assertNotNull((Object)principal);
        Assert.assertEquals((String)"runas", (String)principal.getName());
    }

    public void invokeIsCallerInRole(HttpServletRequest request) {
        Assert.assertTrue((boolean)request.isUserInRole("user"));
        Assert.assertFalse((boolean)request.isUserInRole("manager"));
        Assert.assertFalse((boolean)request.isUserInRole("UNKNOWN"));
        Assert.assertFalse((boolean)request.isUserInRole("runas"));
        Assert.assertFalse((boolean)this.secureEJBLocal.isCallerInRole("user"));
        Assert.assertFalse((boolean)this.secureEJBLocal.isCallerInRole("manager"));
        Assert.assertFalse((boolean)this.secureEJBLocal.isCallerInRole("UNKNOWN"));
        Assert.assertTrue((boolean)this.secureEJBLocal.isCallerInRole("runas"));
    }

    public void invokeIsAllowed(HttpServletRequest request) {
        try {
            this.secureEJBLocal.allowUserMethod();
            Assert.fail((String)"Method allowUserMethod() ALLOWED");
        }
        catch (EJBAccessException expected) {
            // empty catch block
        }
        try {
            this.secureEJBLocal.allowManagerMethod();
            Assert.fail((String)"Method allowManagerMethod() ALLOWED");
        }
        catch (EJBAccessException expected) {
            // empty catch block
        }
        try {
            this.secureEJBLocal.allowUnknownMethod();
            Assert.fail((String)"Method allowUnknownMethod() ALLOWED");
        }
        catch (EJBAccessException expected) {
            // empty catch block
        }
        try {
            this.secureEJBLocal.allowRunasMethod();
        }
        catch (EJBAccessException e) {
            Assert.fail((String)"Method allowRunasMethod() NOT ALLOWED");
        }
        try {
            this.secureEJBLocal.denyAllMethod();
            Assert.fail((String)"Method denyAllMethod() ALLOWED");
        }
        catch (EJBAccessException eJBAccessException) {
            // empty catch block
        }
    }
}

