/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.openejb.mockito.MockRegistry;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.NamedLiteral;
import org.mockito.cglib.proxy.Factory;

public class MockitoExtension
implements Extension {
    private static final Annotation DEFAULT_ANNOTATION = new DefaultLiteral();
    private static final Annotation ANY_ANNOTATION = new AnyLiteral();

    public void addMocks(@Observes AfterBeanDiscovery abd) {
        for (Map.Entry<Class<?>, Object> entry : MockRegistry.mocksByType().entrySet()) {
            abd.addBean(new MockBean(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : MockRegistry.mocksByName().entrySet()) {
            abd.addBean(new NamedMockBean((String)entry.getKey(), entry.getValue()));
        }
    }

    private static class NamedMockBean<T>
    extends MockBean<T> {
        private final String name;
        private final Set<Annotation> qualifiers;

        public NamedMockBean(String named, Object value) {
            super(value.getClass(), value);
            this.name = named;
            if (!this.clazz.isInterface()) {
                this.types.remove(this.clazz);
            }
            this.qualifiers = new HashSet<Annotation>(2);
            this.qualifiers.add(ANY_ANNOTATION);
            this.qualifiers.add((Annotation)new NamedLiteral(this.name));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public T create(CreationalContext<T> context) {
            return this.clazz.cast(this.instance);
        }
    }

    private static class MockBean<T>
    implements Bean<T> {
        protected static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>(2){
            {
                this.add(DEFAULT_ANNOTATION);
                this.add(ANY_ANNOTATION);
            }
        };
        protected final Class<T> clazz;
        protected final Object instance;
        protected final HashSet<Type> types;

        public MockBean(Class<T> key, Object value) {
            this.clazz = key;
            this.instance = value;
            this.types = new HashSet();
            if (this.clazz != null) {
                Class<T> current;
                if (!Proxy.isProxyClass(current)) {
                    for (current = this.clazz; !Object.class.equals(current) && current != null; current = current.getSuperclass()) {
                        this.types.add(current);
                    }
                }
                for (Class<?> itf : this.clazz.getInterfaces()) {
                    if (Factory.class.isAssignableFrom(itf)) continue;
                    this.types.add(itf);
                }
            }
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return QUALIFIERS;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public boolean isNullable() {
            return false;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.clazz;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return true;
        }

        public T create(CreationalContext<T> context) {
            return this.clazz.cast(this.instance);
        }

        public void destroy(T instance, CreationalContext<T> context) {
        }
    }
}

