/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;
import sun.net.util.IPAddressUtil;

public class MulticastPulseAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery").createChild("multipulse"), MulticastPulseAgent.class);
    private static final NetworkInterface[] interfaces = MulticastPulseAgent.getNetworkInterfaces();
    private static final ExecutorService executor = Executors.newFixedThreadPool(interfaces.length + 1);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int TTL = Integer.parseInt(System.getProperty("org.apache.openejb.multipulse.ttl", "32"));
    public static final String SERVER = "OpenEJB.MCP.Server:";
    public static final String CLIENT = "OpenEJB.MCP.Client:";
    public static final String EMPTY = "NoService";
    private final Set<URI> uriSet = new HashSet<URI>();
    private AtomicBoolean running = new AtomicBoolean(false);
    final ArrayList<Future> futures = new ArrayList();
    private MulticastSocket[] sockets = null;
    private InetSocketAddress address = null;
    private String multicast = "239.255.3.2";
    private String group = "default";
    private int port = 6142;
    private DatagramPacket response = null;
    private DiscoveryListener listener = null;
    private boolean loopbackOnly = true;

    public void init(Properties p) throws Exception {
        Options o = new Options(p);
        o.setLogger((Options.Log)new OptionsLog(log));
        this.multicast = p.getProperty("bind", this.multicast);
        this.port = o.get("port", this.port);
        this.group = o.get("group", this.group);
        InetAddress ia = InetAddress.getByName(this.multicast);
        this.address = new InetSocketAddress(ia, this.port);
        this.buildPacket();
    }

    private void buildPacket() throws SocketException {
        this.loopbackOnly = true;
        for (URI uri : this.uriSet) {
            if (MulticastPulseAgent.isLoopback(uri.getHost())) continue;
            this.loopbackOnly = false;
            break;
        }
        String hosts = MulticastPulseAgent.getHosts();
        StringBuilder sb = new StringBuilder(SERVER);
        sb.append(this.group);
        sb.append(':');
        if (this.uriSet.size() > 0) {
            for (URI uri : this.uriSet) {
                sb.append(uri.toASCIIString());
                sb.append('|');
            }
        } else {
            sb.append(EMPTY);
            sb.append('|');
        }
        sb.append(hosts);
        byte[] bytes = sb.toString().getBytes(UTF8);
        this.response = new DatagramPacket(bytes, bytes.length, this.address);
        log.debug("MultiPulse packet is: " + sb);
        if (bytes.length > 2048) {
            log.warning("MultiPulse packet is larger than 2048 bytes, clients will not be able to read the packet");
        }
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener = listener;
    }

    public void registerService(URI uri) throws IOException {
        if (this.uriSet.add(uri = this.parseUri(uri))) {
            this.buildPacket();
            this.fireEvent(uri, true);
        }
    }

    public void unregisterService(URI uri) throws IOException {
        URI tmp = this.parseUri(uri);
        if (this.uriSet.remove(tmp)) {
            this.fireEvent(uri, false);
        }
    }

    public void reportFailed(URI serviceUri) throws IOException {
        this.unregisterService(serviceUri);
    }

    private URI parseUri(URI uri) {
        return URI.create(uri.getSchemeSpecificPart());
    }

    private void fireEvent(final URI uri, final boolean add) {
        if (null != this.listener) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (add) {
                        MulticastPulseAgent.this.listener.serviceAdded(uri);
                    } else {
                        MulticastPulseAgent.this.listener.serviceRemoved(uri);
                    }
                }
            });
        }
    }

    public void start() throws ServiceException {
        if (!this.running.getAndSet(true)) {
            try {
                this.sockets = MulticastPulseAgent.getSockets(this.multicast, this.port);
            }
            catch (Exception e) {
                throw new ServiceException("Failed to get Multicast sockets", (Throwable)e);
            }
            final CountDownLatch latch = new CountDownLatch(this.sockets.length);
            for (final MulticastSocket socket : this.sockets) {
                this.futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        DatagramPacket request = new DatagramPacket(new byte[2048], 2048);
                        latch.countDown();
                        while (MulticastPulseAgent.this.running.get()) {
                            try {
                                String s;
                                socket.receive(request);
                                SocketAddress sa = request.getSocketAddress();
                                if (null == sa || !(s = new String(request.getData(), 0, request.getLength())).startsWith(MulticastPulseAgent.CLIENT)) continue;
                                s = s.replace(MulticastPulseAgent.CLIENT, "");
                                String client = ((InetSocketAddress)sa).getAddress().getHostAddress();
                                if (MulticastPulseAgent.this.group.equals(s) || "*".equals(s)) {
                                    if (MulticastPulseAgent.this.loopbackOnly && !MulticastPulseAgent.isLocalAddress(client, false)) {
                                        log.debug(String.format("Ignoring remote client %1$s pulse request for group: %2$s - No remote services available", client, s));
                                        continue;
                                    }
                                    log.debug(String.format("Answering client %1$s pulse request for group: %2$s", client, s));
                                    socket.send(MulticastPulseAgent.this.response);
                                    continue;
                                }
                                log.debug(String.format("Ignoring client %1$s pulse request for group: %2$s", client, s));
                            }
                            catch (Throwable e) {}
                        }
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }));
            }
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceException {
        if (this.running.getAndSet(false)) {
            try {
                for (Future future : this.futures) {
                    try {
                        future.cancel(true);
                    }
                    catch (Throwable e) {}
                }
                for (Future future : this.futures) {
                    try {
                        future.get();
                    }
                    catch (Throwable e) {}
                }
            }
            finally {
                this.futures.clear();
            }
            if (null != this.sockets) {
                try {
                    for (MulticastSocket s : this.sockets) {
                        try {
                            s.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    this.sockets = null;
                }
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getName() {
        return "multipulse";
    }

    public String getIP() {
        return this.multicast;
    }

    public int getPort() {
        return this.port;
    }

    public static MulticastSocket[] getSockets(String multicastAddress, int port) throws Exception {
        InetAddress ia;
        try {
            ia = InetAddress.getByName(multicastAddress);
        }
        catch (UnknownHostException e) {
            throw new ServiceException(multicastAddress + " is not a valid address", (Throwable)e);
        }
        if (null == ia || !ia.isMulticastAddress()) {
            throw new ServiceException(multicastAddress + " is not a valid multicast address");
        }
        return MulticastPulseAgent.getSockets(ia, port);
    }

    private static MulticastSocket[] getSockets(InetAddress ia, int port) throws Exception {
        ArrayList<MulticastSocket> list = new ArrayList<MulticastSocket>();
        for (NetworkInterface ni : interfaces) {
            MulticastSocket ms = null;
            try {
                ms = new MulticastSocket(port);
                ms.setNetworkInterface(ni);
                ms.setSoTimeout(0);
                ms.setTimeToLive(TTL);
                if (!ms.getBroadcast()) {
                    ms.setBroadcast(true);
                }
                ms.joinGroup(ia);
                list.add(ms);
                log.debug(String.format("Created MulticastSocket for '%1$s:%2$s' on network adapter: %3$s", ia.getHostName(), port, ni));
            }
            catch (Throwable e) {
                if (null == ms) continue;
                try {
                    ms.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new MulticastSocket[list.size()]);
    }

    private static NetworkInterface[] getNetworkInterfaces() {
        HashSet<NetworkInterface> list = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface next = interfaces.nextElement();
                if (!next.supportsMulticast() || !next.isUp()) continue;
                list.add(next);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return list.toArray(new NetworkInterface[list.size()]);
    }

    public static boolean isLoopback(String host) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return addr.isLoopbackAddress();
    }

    public static boolean isLocalAddress(String host, boolean wildcardIsLocal) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (wildcardIsLocal && addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static String getHosts() {
        TreeSet<String> hosts = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String h1, String h2) {
                try {
                    if (IPAddressUtil.isIPv4LiteralAddress(h1)) {
                        if (IPAddressUtil.isIPv6LiteralAddress(h2.replace("[", "").replace("]", ""))) {
                            return -1;
                        }
                    } else if (IPAddressUtil.isIPv6LiteralAddress(h1.replace("[", "").replace("]", ""))) {
                        if (IPAddressUtil.isIPv4LiteralAddress(h2)) {
                            return 1;
                        }
                    } else if (0 != h1.compareTo(h2)) {
                        return -1;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return h1.compareTo(h2);
            }
        });
        try {
            InetAddress[] all;
            InetAddress localhost = InetAddress.getLocalHost();
            hosts.add(localhost.getHostAddress());
            for (InetAddress ip : all = InetAddress.getAllByName(localhost.getCanonicalHostName())) {
                String ha;
                if (ip.isLinkLocalAddress() || ip.isMulticastAddress() || (ha = ip.getHostAddress()).replace("[", "").startsWith("2001:0:")) continue;
                hosts.add(ha);
                hosts.add(ip.getCanonicalHostName());
            }
        }
        catch (UnknownHostException e) {
            log.warning("Failed to list machine hosts", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (String host : hosts) {
            String lc = host.toLowerCase();
            if ("localhost".equals(lc) || "::1".equals(lc) || "127.0.0.1".equals(lc)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(host);
        }
        return sb.toString();
    }
}

