/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.monitoring.Event;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.openejb.server.discovery.Tracker;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Managed
public class MultipointServer {
    private static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery").createChild("multipoint"), MultipointServer.class);
    private static final URI END_LIST = URI.create("end:list");
    private final int port;
    private final URI me;
    private final Set<URI> roots = new LinkedHashSet<URI>();
    private final Event runs = new Event();
    private final Event heartbeats = new Event();
    private final Event reconnects = new Event();
    private final Event sessionsCreated = new Event();
    private final String name;
    private final Tracker tracker;
    private final LinkedList<Host> connect = new LinkedList();
    private final Map<URI, Session> connections = new HashMap<URI, Session>();
    private long joined = 0L;
    private final long reconnectDelay;
    private final ServerSocketChannel serverChannel;
    private final Selector selector;
    private final Lock lock = new ReentrantLock();
    private final Condition started = this.lock.newCondition();
    private final Condition stopped = this.lock.newCondition();
    private final AtomicBoolean running = new AtomicBoolean();
    private final Executor dnsResolutionQueue = Executors.newFixedThreadPool(2);

    public MultipointServer(int port, Tracker tracker) throws IOException {
        this("localhost", "localhost", port, tracker, MultipointServer.randomColor(), true, new HashSet<URI>(0), new Duration(30L, TimeUnit.SECONDS));
    }

    public MultipointServer(String bindHost, String broadcastHost, int port, Tracker tracker, String name, boolean debug, Set<URI> roots, Duration reconnectDelay) throws IOException {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (bindHost == null) {
            throw new NullPointerException("host cannot be null");
        }
        if (broadcastHost == null) {
            broadcastHost = bindHost;
        }
        if (reconnectDelay == null) {
            reconnectDelay = new Duration(30L, TimeUnit.SECONDS);
        }
        this.tracker = tracker;
        this.name = name;
        if (roots != null) {
            for (URI uri : roots) {
                this.roots.add(this.normalize(uri));
            }
        }
        this.reconnectDelay = reconnectDelay.getTime(TimeUnit.NANOSECONDS);
        String format = String.format("MultipointServer(bindHost=%s, discoveryHost=%s, port=%s, name=%s, debug=%s, roots=%s, reconnectDelay='%s')", bindHost, broadcastHost, port, name, debug, this.roots.size(), reconnectDelay.toString());
        log.debug(format);
        this.selector = Selector.open();
        InetSocketAddress address = new InetSocketAddress(bindHost, port);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        serverSocket.bind(address);
        this.port = serverSocket.getLocalPort();
        this.me = this.createURI(broadcastHost, this.port);
        this.serverChannel.register(this.selector, 16);
        this.println("Broadcasting");
    }

    private URI normalize(URI uri) {
        return this.createURI(uri.getHost(), uri.getPort());
    }

    private URI createURI(String host, int port) {
        return URI.create("conn://" + host.toLowerCase() + ":" + port);
    }

    public URI getMe() {
        return this.me;
    }

    public Set<URI> getRoots() {
        return this.roots;
    }

    public Event getRuns() {
        return this.runs;
    }

    public Event getHeartbeats() {
        return this.heartbeats;
    }

    public Event getReconnects() {
        return this.reconnects;
    }

    public Event getSessionsCreated() {
        return this.sessionsCreated;
    }

    public String getName() {
        return this.name;
    }

    public long getJoined() {
        return this.joined;
    }

    public List<URI> getSessions() {
        return new ArrayList<URI>(this.connections.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URI> getConnectionsQueued() {
        LinkedList<Host> linkedList = this.connect;
        synchronized (linkedList) {
            ArrayList<URI> uris = new ArrayList<URI>(this.connect.size());
            for (Host host : this.connect) {
                uris.add(host.getUri());
            }
            return uris;
        }
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rejoin() {
        if (this.roots.size() <= 0) {
            return;
        }
        if (System.nanoTime() - this.joined <= this.reconnectDelay) {
            return;
        }
        for (URI uri : this.roots) {
            Host host = new Host(uri);
            LinkedList<Host> linkedList = this.connect;
            synchronized (linkedList) {
                if (!this.connections.containsKey(uri) && !this.connect.contains(host)) {
                    log.info("Reconnect{uri=" + uri + "}");
                    this.connect.addLast(host);
                    host.resolveDns();
                    this.joined = System.nanoTime();
                }
            }
        }
    }

    public MultipointServer start() {
        if (this.running.compareAndSet(false, true)) {
            String multipointServer = Join.join((String)".", (Object[])new Object[]{"MultipointServer", this.name, this.port});
            log.info("MultipointServer Starting : Thread '" + multipointServer + "'");
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MultipointServer.this.signal(MultipointServer.this.started);
                    try {
                        MultipointServer.this._run();
                    }
                    finally {
                        MultipointServer.this.signal(MultipointServer.this.stopped);
                    }
                }
            });
            thread.setName(multipointServer);
            thread.start();
            this.await(this.started, 10L, TimeUnit.SECONDS);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal(Condition condition) {
        this.lock.lock();
        try {
            condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await(Condition condition, long time, TimeUnit unit) {
        this.lock.lock();
        try {
            condition.await(time, unit);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.running.set(false);
        try {
            this.serverChannel.close();
        }
        catch (IOException e) {
            throw new CloseException(e);
        }
        finally {
            this.await(this.stopped, 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _run() {
        long selectorTimeout = this.tracker.getHeartRate();
        int failed = 0;
        while (this.running.get()) {
            Session session;
            this.runs.record();
            long start = System.nanoTime();
            try {
                this.selector.select(selectorTimeout);
                failed = 0;
            }
            catch (IOException ex) {
                if (failed++ > 100) {
                    log.fatal("Too many Multipoint Failures.  Terminating service.", (Throwable)ex);
                    return;
                }
                log.error("Multipoint Failure.", (Throwable)ex);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Session session2;
                LinkedList<Host> linkedList;
                SelectionKey key = iterator.next();
                iterator.remove();
                try {
                    if (key.isAcceptable()) {
                        this.doAccept(key);
                    }
                    if (key.isConnectable()) {
                        this.doConnect(key);
                    }
                    if (key.isReadable()) {
                        this.doRead(key);
                    }
                    if (!key.isWritable()) continue;
                    this.doWrite(key);
                }
                catch (CancelledKeyException ex) {
                    linkedList = this.connect;
                    synchronized (linkedList) {
                        session2 = (Session)key.attachment();
                        if (session2.state != State.CLOSED) {
                            this.close(key);
                        }
                    }
                }
                catch (ClosedChannelException ex) {
                    linkedList = this.connect;
                    synchronized (linkedList) {
                        session2 = (Session)key.attachment();
                        if (session2.state != State.CLOSED) {
                            this.close(key);
                        }
                    }
                }
                catch (IOException ex) {
                    session = (Session)key.attachment();
                    session.trace(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    this.close(key);
                }
            }
            for (SelectionKey key : this.selector.keys()) {
                session = (Session)key.attachment();
                try {
                    if (session == null || session.state != State.HEARTBEAT) continue;
                    session.tick();
                }
                catch (IOException ex) {
                    this.close(key);
                }
            }
            this.tracker.checkServices();
            this.rejoin();
            this.initiateConnections();
            selectorTimeout = this.adjustedSelectorTimeout(start);
        }
        log.info("MultipointServer has terminated.");
    }

    private long adjustedSelectorTimeout(long start) {
        long end = System.nanoTime();
        long elapsed = TimeUnit.NANOSECONDS.toMillis(end - start);
        long heartRate = this.tracker.getHeartRate();
        return Math.max(1L, heartRate - elapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateConnections() {
        LinkedList<Host> linkedList = this.connect;
        synchronized (linkedList) {
            LinkedList<Host> unresolved = new LinkedList<Host>();
            while (this.connect.size() > 0) {
                InetSocketAddress address;
                Host host = this.connect.removeFirst();
                log.debug("Initiate(uri=" + host.getUri() + ")");
                if (this.connections.containsKey(host.getUri())) continue;
                if (!host.isDone()) {
                    unresolved.add(host);
                    log.debug("Unresolved(uri=" + host.getUri() + ")");
                    continue;
                }
                try {
                    address = host.getSocketAddress();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause() != null ? e.getCause() : e;
                    String message = String.format("Failed Connect{uri=%s} %s{message=\"%s\"}", host.getUri(), t.getClass().getSimpleName(), t.getMessage());
                    log.warning(message);
                    continue;
                }
                catch (TimeoutException e) {
                    unresolved.add(host);
                    log.debug("Unresolved(uri=" + host.getUri() + ")");
                    continue;
                }
                try {
                    URI uri = host.getUri();
                    this.println("open " + uri);
                    SocketChannel socketChannel = SocketChannel.open();
                    socketChannel.configureBlocking(false);
                    socketChannel.connect(address);
                    Session session = new Session(socketChannel, address, uri);
                    session.ops(8);
                    session.trace("client");
                    this.connections.put(session.uri, session);
                }
                catch (IOException e) {
                    throw new ServerRuntimeException((Exception)e);
                }
            }
            this.connect.addAll(unresolved);
        }
    }

    private void doWrite(SelectionKey key) throws IOException {
        Session session = (Session)key.attachment();
        switch (session.state) {
            case GREETING: {
                if (!session.drain()) break;
                session.state(1, State.LISTING);
                break;
            }
            case LISTING: {
                if (!session.drain()) break;
                if (session.client) {
                    session.state(1, State.HEARTBEAT);
                    break;
                }
                session.state(1, State.LISTING);
                break;
            }
            case HEARTBEAT: {
                if (!session.drain()) break;
                session.last = System.currentTimeMillis();
                session.state(1, State.HEARTBEAT);
            }
        }
    }

    private void doRead(SelectionKey key) throws IOException {
        Session session = (Session)key.attachment();
        block1 : switch (session.state) {
            case GREETING: {
                String message = session.read();
                if (message == null) break;
                session.setURI(URI.create(message));
                this.connected(session);
                session.trace("welcome");
                ArrayList<URI> list = this.connections();
                list.remove(this.me);
                list.add(END_LIST);
                session.write(list);
                session.state(4, State.LISTING);
                session.trace("STARTING");
                break;
            }
            case LISTING: {
                String message;
                while ((message = session.read()) != null) {
                    URI uri = URI.create(message);
                    if (END_LIST.equals(uri)) {
                        if (session.client) {
                            ArrayList<URI> list = this.connections();
                            for (URI reported : session.listed) {
                                list.remove(reported);
                            }
                            list.remove(session.uri);
                            list.add(END_LIST);
                            session.write(list);
                            session.state(4, State.LISTING);
                            break block1;
                        }
                        if (session.hangup) {
                            session.state(0, State.CLOSED);
                            session.trace("hangup");
                            this.hangup(key);
                            break block1;
                        }
                        session.trace("DONE READING");
                        session.state(1, State.HEARTBEAT);
                        break block1;
                    }
                    session.listed.add(uri);
                    try {
                        this.connect(uri);
                    }
                    catch (Exception e) {
                        this.println("connect failed " + uri + " - " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                break;
            }
            case HEARTBEAT: {
                String message;
                while ((message = session.read()) != null) {
                    this.tracker.processData(message);
                }
                break;
            }
        }
    }

    private void doConnect(SelectionKey key) throws IOException {
        Session session = (Session)key.attachment();
        session.channel.finishConnect();
        session.trace("connected");
        session.write(this.me);
        session.state(4, State.GREETING);
    }

    private void doAccept(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel client = server.accept();
        InetSocketAddress address = (InetSocketAddress)client.socket().getRemoteSocketAddress();
        client.configureBlocking(false);
        Session session = new Session(client, address, null);
        session.trace("accept");
        session.state(1, State.GREETING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<URI> connections() {
        LinkedList<Host> linkedList = this.connect;
        synchronized (linkedList) {
            ArrayList<URI> list = new ArrayList<URI>(this.connections.keySet());
            for (Host host : this.connect) {
                list.add(host.getUri());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(SelectionKey key) {
        Session session = (Session)key.attachment();
        if (session.hangup) {
            log.info("Hungup " + session);
            session.trace("hungup");
        } else {
            log.info("Closed " + session);
            session.trace("closed");
            LinkedList<Host> linkedList = this.connect;
            synchronized (linkedList) {
                this.connections.remove(session.uri);
            }
        }
        session.state(0, State.CLOSED);
        this.hangup(key);
    }

    private void hangup(SelectionKey key) {
        key.cancel();
        try {
            key.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect(MultipointServer s) throws Exception {
        this.connect(s.port);
    }

    public void connect(int port) throws Exception {
        this.connect(URI.create("conn://localhost:" + port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(URI uri) {
        if (this.me.equals(uri = this.normalize(uri))) {
            return;
        }
        Host host = new Host(uri);
        LinkedList<Host> linkedList = this.connect;
        synchronized (linkedList) {
            if (!this.connections.containsKey(uri) && !this.connect.contains(host)) {
                log.info("Queuing{uri=" + uri + "}");
                this.connect.addLast(host);
                host.resolveDns();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connected(Session session) {
        LinkedList<Host> linkedList = this.connect;
        synchronized (linkedList) {
            Session duplicate = this.connections.get(session.uri);
            if (duplicate != null) {
                session.trace("duplicate");
                Session[] sessions = new Session[]{session, duplicate};
                if (!sessions[0].client && !sessions[1].client) {
                    Arrays.sort(sessions, new Comparator<Session>(){

                        @Override
                        public int compare(Session a, Session b) {
                            return (int)(b.created - a.created);
                        }
                    });
                } else {
                    Arrays.sort(sessions, new Comparator<Session>(){

                        @Override
                        public int compare(Session a, Session b) {
                            int serverRank = this.server(a) - this.server(b);
                            if (serverRank != 0) {
                                return serverRank;
                            }
                            return this.client(a) - this.client(b);
                        }

                        private int server(Session a) {
                            Socket socket = a.channel.socket();
                            return a.client ? socket.getPort() : socket.getLocalPort();
                        }

                        private int client(Session a) {
                            Socket socket = a.channel.socket();
                            return !a.client ? socket.getPort() : socket.getLocalPort();
                        }
                    });
                }
                session = sessions[0];
                duplicate = sessions[1];
                session.trace(session + "@" + session.hashCode() + " KEEP");
                duplicate.trace(duplicate + "@" + duplicate.hashCode() + " KILL");
                duplicate.hangup = true;
            }
            if (session.state == State.GREETING) {
                session.info(session + "@" + session.hashCode() + " DISCOVERED");
            }
            this.connections.put(session.uri, session);
        }
    }

    private void println(String s) {
    }

    public String toString() {
        return "MultipointServer{name='" + this.name + '\'' + ", me=" + this.me + '}';
    }

    public static String randomColor() {
        String[] colors = new String[]{"almond", "amber", "amethyst", "apple", "apricot", "aqua", "aquamarine", "ash", "azure", "banana", "beige", "black", "blue", "brick", "bronze", "brown", "burgundy", "carrot", "charcoal", "cherry", "chestnut", "chocolate", "chrome", "cinnamon", "citrine", "cobalt", "copper", "coral", "cornflower", "cotton", "cream", "crimson", "cyan", "ebony", "emerald", "forest", "fuchsia", "ginger", "gold", "goldenrod", "gray", "green", "grey", "indigo", "ivory", "jade", "jasmine", "khaki", "lava", "lavender", "lemon", "lilac", "lime", "macaroni", "magenta", "magnolia", "mahogany", "malachite", "mango", "maroon", "mauve", "mint", "moonstone", "navy", "ocean", "olive", "onyx", "orange", "orchid", "papaya", "peach", "pear", "pearl", "periwinkle", "pine", "pink", "pistachio", "platinum", "plum", "prune", "pumpkin", "purple", "quartz", "raspberry", "red", "rose", "rosewood", "ruby", "salmon", "sapphire", "scarlet", "sienna", "silver", "slate", "strawberry", "tan", "tangerine", "taupe", "teal", "titanium", "topaz", "turquoise", "umber", "vanilla", "violet", "watermelon", "white", "yellow"};
        Random random = new Random();
        long l = random.nextLong();
        if (l < 0L) {
            l *= -1L;
        }
        long index = l % (long)colors.length;
        return colors[(int)index];
    }

    private class Host {
        private final URI uri;
        private final FutureTask<InetAddress> address;

        private Host(URI uri) {
            this.uri = uri;
            this.address = new FutureTask<InetAddress>(new Callable<InetAddress>(){

                @Override
                public InetAddress call() throws Exception {
                    return InetAddress.getByName(Host.this.uri.getHost());
                }
            });
        }

        public void resolveDns() {
            MultipointServer.this.dnsResolutionQueue.execute(this.address);
        }

        public boolean isDone() {
            return this.address.isDone();
        }

        public InetSocketAddress getSocketAddress() throws ExecutionException, TimeoutException {
            try {
                InetAddress inetAddress = this.address.get(0L, TimeUnit.NANOSECONDS);
                return new InetSocketAddress(inetAddress, this.uri.getPort());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new TimeoutException();
            }
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Host host = (Host)o;
            return this.uri.equals(host.uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }

    private static enum State {
        OPEN,
        GREETING,
        LISTING,
        HEARTBEAT,
        CLOSED;

    }

    public class Session {
        private static final int EOF = 3;
        private final SocketChannel channel;
        private final ByteBuffer read = ByteBuffer.allocate(1024);
        private final SelectionKey key;
        private final List<URI> listed = new ArrayList<URI>();
        private final long created = System.currentTimeMillis();
        private ByteBuffer write;
        @Managed
        private State state = State.OPEN;
        private URI uri;
        public boolean hangup;
        private final boolean client;
        private long last = 0L;

        public Session(SocketChannel channel, InetSocketAddress address, URI uri) throws ClosedChannelException {
            this.channel = channel;
            this.client = uri != null;
            this.uri = uri != null ? uri : MultipointServer.this.createURI(address.getHostName(), address.getPort());
            this.key = channel.register(MultipointServer.this.selector, 0, this);
            MultipointServer.this.sessionsCreated.record();
            log.info("Constructing " + this);
        }

        public Session ops(int ops) {
            this.key.interestOps(ops);
            return this;
        }

        public long getCreated() {
            return this.created;
        }

        public void state(int ops, State state) {
            if (this.state != state && log.isDebugEnabled()) {
                log.debug(this.message(state.name()));
            }
            this.state = state;
            if (ops > 0) {
                this.key.interestOps(ops);
            }
        }

        public void setURI(URI uri) {
            this.uri = uri;
        }

        private void trace(String str) {
            if (log.isDebugEnabled()) {
                log.debug(this.message(str));
            }
        }

        private void info(String str) {
            if (log.isInfoEnabled()) {
                log.info(this.message(str));
            }
        }

        private String message(String str) {
            StringBuilder sb = new StringBuilder();
            sb.append(MultipointServer.this.name);
            sb.append(":");
            sb.append(MultipointServer.this.port);
            sb.append(" ");
            if (this.key.isValid()) {
                if ((this.key.interestOps() & 1) == 1) {
                    sb.append("<");
                }
                if ((this.key.interestOps() & 4) == 4) {
                    sb.append(">");
                }
                if (this.key.interestOps() == 0) {
                    sb.append("-");
                }
            } else {
                sb.append(":");
            }
            sb.append(" ");
            sb.append(this.uri.getPort());
            sb.append(" ");
            sb.append((Object)this.state);
            sb.append(" ");
            sb.append(str);
            return sb.toString();
        }

        public void write(URI uri) throws IOException {
            this.write(Arrays.asList(uri));
        }

        public void write(Collection<?> uris) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (Object uri : uris) {
                String s = uri.toString();
                byte[] b = s.getBytes("UTF-8");
                baos.write(b);
                baos.write(3);
            }
            this.write = ByteBuffer.wrap(baos.toByteArray());
        }

        public boolean drain() throws IOException {
            this.channel.write(this.write);
            return this.write.remaining() == 0;
        }

        public String read() throws IOException {
            if (this.channel.read(this.read) == -1) {
                throw new EOFException();
            }
            byte[] buf = this.read.array();
            int end = this.endOfText(buf, 0, this.read.position());
            if (end < 0) {
                return null;
            }
            String text = new String(buf, 0, end, "UTF-8");
            int newPos = this.read.position() - end;
            System.arraycopy(buf, end + 1, buf, 0, newPos - 1);
            this.read.position(newPos - 1);
            return text;
        }

        private int endOfText(byte[] data, int offset, int pos) {
            for (int i = offset; i < pos; ++i) {
                if (data[i] != 3) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            return "Session{uri=" + this.uri + ", created=" + this.created + ", state=" + (Object)((Object)this.state) + ", owner=" + MultipointServer.this.port + ", s=" + (this.client ? this.channel.socket().getPort() : this.channel.socket().getLocalPort()) + ", c=" + (!this.client ? this.channel.socket().getPort() : this.channel.socket().getLocalPort()) + ", " + (this.client ? "client" : "server") + '}';
        }

        public void tick() throws IOException {
            if (this.state != State.HEARTBEAT) {
                return;
            }
            long now = System.currentTimeMillis();
            long delay = now - this.last;
            if (delay >= MultipointServer.this.tracker.getHeartRate()) {
                this.last = now;
                this.heartbeat();
            }
        }

        private void heartbeat() throws IOException {
            MultipointServer.this.heartbeats.record();
            Set<String> strings = MultipointServer.this.tracker.getRegisteredServices();
            this.write(strings);
            this.state(5, State.HEARTBEAT);
        }
    }

    public static class CloseException
    extends RuntimeException {
        public CloseException(Throwable cause) {
            super(cause);
        }
    }
}

