/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.rest.OpenEJBRestRuntimeException;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsRegistryImpl;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;

public abstract class RESTService
implements ServerService,
SelfManaging,
DeploymentListener {
    public static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, RESTService.class);
    private static final boolean OLD_WEBSERVICE_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false);
    private static final String IP = "n/a";
    private static final int PORT = -1;
    public static final String NOPATH_PREFIX = "http://nopath/";
    private final Set<AppInfo> deployedApplications = new HashSet<AppInfo>();
    private final Set<WebAppInfo> deployedWebApps = new HashSet<WebAppInfo>();
    private Assembler assembler;
    private CoreContainerSystem containerSystem;
    private RsRegistry rsRegistry;
    private List<String> services = new ArrayList<String>();
    private String virtualHost;

    public void afterApplicationCreated(AppInfo appInfo, WebAppInfo webApp) {
        Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo);
        WebContext webContext = this.containerSystem.getWebContext(webApp.moduleId);
        if (webContext == null) {
            return;
        }
        if (!this.deployedWebApps.add(webApp)) {
            return;
        }
        ClassLoader classLoader = RESTService.getClassLoader(webContext.getClassLoader());
        Collection injections = webContext.getInjections();
        WebBeansContext owbCtx = webContext.getAppContext().getWebBeansContext();
        Context context = webContext.getJndiEnc();
        if (context == null) {
            context = webContext.getAppContext().getAppJndiContext();
        }
        boolean useApp = false;
        String appPrefix = webApp.contextRoot;
        for (String app : webApp.restApplications) {
            Application appInstance;
            Class<?> appClazz;
            appPrefix = webApp.contextRoot;
            if (!appPrefix.endsWith("/")) {
                appPrefix = appPrefix + "/";
            }
            try {
                appClazz = classLoader.loadClass(app);
                appInstance = (Application)Application.class.cast(appClazz.newInstance());
            }
            catch (Exception e) {
                throw new OpenEJBRestRuntimeException("can't create class " + app, e);
            }
            ApplicationPath path = appClazz.getAnnotation(ApplicationPath.class);
            if (path != null) {
                String appPath = path.value();
                appPrefix = appPath.startsWith("/") ? appPrefix + appPath.substring(1) : appPrefix + appPath;
            }
            Set singletons = appInstance.getSingletons();
            for (Object o : singletons) {
                if (o == null) continue;
                if (restEjbs.containsKey(o.getClass().getName())) {
                    this.deployEJB(appPrefix, restEjbs.get((Object)o.getClass().getName()).context);
                    continue;
                }
                this.deploySingleton(appPrefix, o, appInstance, classLoader);
            }
            Set classes = appInstance.getClasses();
            for (Class clazz : classes) {
                if (restEjbs.containsKey(clazz.getName())) {
                    this.deployEJB(appPrefix, restEjbs.get((Object)clazz.getName()).context);
                    continue;
                }
                this.deployPojo(appPrefix, clazz, appInstance, classLoader, injections, context, owbCtx);
            }
            useApp = useApp || classes.size() + singletons.size() > 0;
            LOGGER.info("REST application deployed: " + app);
        }
        if (!useApp) {
            HashSet restClasses = new HashSet(webApp.restClass);
            restClasses.addAll(webApp.ejbRestServices);
            for (String clazz : restClasses) {
                if (restEjbs.containsKey(clazz)) {
                    this.deployEJB(appPrefix, restEjbs.get((Object)clazz).context);
                    continue;
                }
                try {
                    Class<?> loadedClazz = classLoader.loadClass(clazz);
                    this.deployPojo(appPrefix, loadedClazz, null, classLoader, injections, context, owbCtx);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBRestRuntimeException("can't find class " + clazz, e);
                }
            }
        }
        restEjbs.clear();
    }

    public void afterApplicationCreated(AppInfo appInfo) {
        if (this.deployedApplications.add(appInfo)) {
            if (appInfo.webApps.size() == 0) {
                Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo);
                for (Map.Entry<String, EJBRestServiceInfo> ejb : restEjbs.entrySet()) {
                    this.deployEJB(ejb.getValue().path, ejb.getValue().context);
                }
                restEjbs.clear();
            } else {
                for (WebAppInfo webApp : appInfo.webApps) {
                    this.afterApplicationCreated(appInfo, webApp);
                }
            }
        }
    }

    protected Map<String, EJBRestServiceInfo> getRestEjbs(AppInfo appInfo) {
        HashMap<String, BeanContext> beanContexts = new HashMap<String, BeanContext>();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                BeanContext beanContext;
                if (!bean.restService || (beanContext = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId)) == null) continue;
                beanContexts.put(bean.ejbClass, beanContext);
            }
        }
        HashMap<String, EJBRestServiceInfo> restEjbs = new HashMap<String, EJBRestServiceInfo>();
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            for (String ejb : webAppInfo.ejbRestServices) {
                restEjbs.put(ejb, new EJBRestServiceInfo(webAppInfo.contextRoot, (BeanContext)beanContexts.get(ejb)));
            }
        }
        for (Map.Entry entry : beanContexts.entrySet()) {
            String clazz = (String)entry.getKey();
            if (restEjbs.containsKey(clazz)) continue;
            String context = null;
            if (!OLD_WEBSERVICE_DEPLOYMENT) {
                context = appInfo.appId != null && !appInfo.appId.isEmpty() ? appInfo.appId : ((BeanContext)entry.getValue()).getModuleName();
            }
            restEjbs.put(clazz, new EJBRestServiceInfo(context, (BeanContext)beanContexts.get(clazz)));
        }
        beanContexts.clear();
        return restEjbs;
    }

    private void deploySingleton(String contextRoot, Object o, Application appInstance, ClassLoader classLoader) {
        String nopath = this.getAddress(contextRoot, o.getClass()) + "/.*";
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(contextRoot, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(address.complete);
        listener.deploySingleton(RESTService.getFullContext(address.base, contextRoot), o, appInstance);
        LOGGER.info("deployed REST singleton: " + o);
    }

    private static String baseAddress(String address, String contextRoot) {
        if (contextRoot == null || contextRoot.isEmpty()) {
            return address;
        }
        int idx = address.indexOf(contextRoot);
        return address.substring(0, idx) + contextRoot;
    }

    private void deployPojo(String contextRoot, Class<?> loadedClazz, Application app, ClassLoader classLoader, Collection<Injection> injections, Context context, WebBeansContext owbCtx) {
        if (loadedClazz.isInterface()) {
            return;
        }
        String nopath = this.getAddress(contextRoot, loadedClazz) + "/.*";
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(contextRoot, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(address.complete);
        listener.deployPojo(RESTService.getFullContext(address.base, contextRoot), loadedClazz, app, injections, context, owbCtx);
        LOGGER.info("REST Service: " + address.complete + "  -> Pojo " + loadedClazz.getName());
    }

    private void deployEJB(String context, BeanContext beanContext) {
        String nopath = this.getAddress(context, beanContext.getBeanClass()) + "/.*";
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(context, listener, beanContext.getClassLoader(), nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(address.complete);
        listener.deployEJB(RESTService.getFullContext(address.base, context), beanContext);
        LOGGER.info("REST Service: " + address.complete + "  -> EJB " + beanContext.getEjbName());
    }

    protected abstract RsHttpListener createHttpListener();

    private static String getFullContext(String address, String context) {
        int idx;
        String base;
        if (context == null) {
            return address;
        }
        if (context.isEmpty() && address.contains("/")) {
            return address.substring(0, address.lastIndexOf("/"));
        }
        String webCtx = context;
        if (webCtx.contains("/")) {
            webCtx = webCtx.substring(0, webCtx.indexOf("/"));
        }
        if (!(base = address.substring(0, idx = address.indexOf(webCtx))).endsWith("/") && !webCtx.startsWith("/")) {
            base = base + '/';
        }
        return base + context;
    }

    private String getAddress(String context, Class<?> clazz) {
        String root = NOPATH_PREFIX;
        if (context != null) {
            root = root + context;
        }
        Class<?> usedClass = clazz;
        while (usedClass.getAnnotation(Path.class) == null && usedClass.getSuperclass() != null) {
            usedClass = usedClass.getSuperclass();
        }
        if (usedClass == null) {
            throw new IllegalArgumentException("no @Path annotation on " + clazz.getName());
        }
        try {
            return UriBuilder.fromUri((URI)new URI(root)).path(usedClass).build(new Object[0]).toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBRestRuntimeException("url is malformed", e);
        }
        catch (URISyntaxException e) {
            throw new OpenEJBRestRuntimeException("uri syntax is not correct", e);
        }
    }

    private void undeployRestObject(String context) {
        HttpListener listener = this.rsRegistry.removeListener(context);
        if (listener != null) {
            ((RsHttpListener)RsHttpListener.class.cast(listener)).undeploy();
        }
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = RESTService.class.getClassLoader();
        }
        return cl;
    }

    public void beforeApplicationDestroyed(AppInfo appInfo) {
        if (this.deployedApplications.contains(appInfo)) {
            for (WebAppInfo webApp : appInfo.webApps) {
                for (String address : this.services) {
                    if (!address.endsWith(webApp.contextRoot)) continue;
                    this.undeployRestObject(address);
                }
                this.deployedWebApps.remove(webApp);
            }
        }
    }

    public void start() throws ServiceException {
        SystemInstance.get().setComponent(RESTService.class, (Object)this);
        this.beforeStart();
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        if (this.assembler != null) {
            this.assembler.addDeploymentListener((DeploymentListener)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                this.afterApplicationCreated(appInfo);
            }
        }
    }

    protected void beforeStart() {
        this.rsRegistry = (RsRegistry)SystemInstance.get().getComponent(RsRegistry.class);
        if (this.rsRegistry == null && SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
            this.rsRegistry = new RsRegistryImpl();
        }
    }

    public void stop() throws ServiceException {
        for (String address : this.services) {
            this.undeployRestObject(address);
        }
        if (this.assembler != null) {
            this.assembler.removeDeploymentListener((DeploymentListener)this);
            for (AppInfo appInfo : new ArrayList<AppInfo>(this.deployedApplications)) {
                this.beforeApplicationDestroyed(appInfo);
            }
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public String getIP() {
        return IP;
    }

    public int getPort() {
        return -1;
    }

    public void init(Properties props) throws Exception {
        this.virtualHost = props.getProperty("virtualHost");
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public static class EJBRestServiceInfo {
        public String path;
        public BeanContext context;

        public EJBRestServiceInfo(String path, BeanContext context) {
            if (context == null) {
                throw new OpenEJBRestRuntimeException("can't find context");
            }
            this.path = path;
            this.context = context;
        }
    }
}

