/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.Injection;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.util.PojoUtil;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.rest.OpenEJBRestRuntimeException;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsRegistryImpl;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.xbean.finder.MetaAnnotatedClass;

public abstract class RESTService
implements ServerService,
SelfManaging {
    public static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, RESTService.class);
    private static final boolean OLD_WEBSERVICE_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false);
    public static final String OPENEJB_JAXRS_PROVIDERS_AUTO_PROP = "openejb.jaxrs.providers.auto";
    private static final String IP = "n/a";
    private static final int PORT = -1;
    public static final String NOPATH_PREFIX = "http://nopath/";
    private final Set<AppInfo> deployedApplications = new HashSet<AppInfo>();
    private final Set<WebAppInfo> deployedWebApps = new HashSet<WebAppInfo>();
    private Assembler assembler;
    private CoreContainerSystem containerSystem;
    private RsRegistry rsRegistry;
    private List<DeployedService> services = new ArrayList<DeployedService>();
    private String virtualHost;
    private boolean enabled = true;
    private String wildcard = SystemInstance.get().getProperty("openejb.rest.wildcard", ".*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterApplicationCreated(AppInfo appInfo, WebAppInfo webApp) {
        Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo);
        WebContext webContext = this.containerSystem.getWebContext(webApp.moduleId);
        if (webContext == null) {
            return;
        }
        if (!this.deployedWebApps.add(webApp)) {
            return;
        }
        ClassLoader classLoader = RESTService.getClassLoader(webContext.getClassLoader());
        Collection injections = webContext.getInjections();
        WebBeansContext owbCtx = webContext.getWebbeansContext() != null ? webContext.getWebbeansContext() : webContext.getAppContext().getWebBeansContext();
        Context context = webContext.getJndiEnc();
        if (context == null) {
            context = webContext.getAppContext().getAppJndiContext();
        }
        HashSet<Object> additionalProviders = new HashSet<Object>();
        if (this.useDiscoveredProviders()) {
            for (String name : webApp.jaxRsProviders) {
                try {
                    additionalProviders.add(classLoader.loadClass(name));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warning("can't load '" + name + "'", (Throwable)e);
                }
            }
            additionalProviders.addAll(this.appProviders(appInfo, classLoader));
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            boolean useApp = false;
            String appPrefix = webApp.contextRoot;
            Collection pojoConfigurations = null;
            for (String app : webApp.restApplications) {
                Application appInstance;
                Class<?> appClazz;
                appPrefix = webApp.contextRoot;
                if (!appPrefix.endsWith("/")) {
                    appPrefix = appPrefix + "/";
                }
                try {
                    appClazz = classLoader.loadClass(app);
                    appInstance = (Application)Application.class.cast(appClazz.newInstance());
                }
                catch (Exception e) {
                    throw new OpenEJBRestRuntimeException("can't create class " + app, e);
                }
                ApplicationPath path = appClazz.getAnnotation(ApplicationPath.class);
                if (path != null) {
                    String appPath = path.value();
                    appPrefix = appPath.startsWith("/") ? appPrefix + appPath.substring(1) : appPrefix + appPath;
                }
                Set classes = appInstance.getClasses();
                Set singletons = appInstance.getSingletons();
                for (Class clazz : classes) {
                    if (!RESTService.isProvider(clazz)) continue;
                    additionalProviders.add(clazz);
                }
                for (Object obj : singletons) {
                    if (obj == null || !RESTService.isProvider(obj.getClass())) continue;
                    additionalProviders.add(obj);
                }
                for (Object o : singletons) {
                    if (o == null) continue;
                    if (this.hasEjbAndIsNotAManagedBean(restEjbs, o.getClass().getName())) {
                        this.deployEJB(webApp.contextRoot, appPrefix, restEjbs.get((Object)o.getClass().getName()).context, additionalProviders, appInfo.services);
                        continue;
                    }
                    pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                    this.deploySingleton(webApp.contextRoot, appPrefix, o, appInstance, classLoader, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)o.getClass().getName()), (Collection)appInfo.services));
                }
                for (Class clazz : classes) {
                    if (additionalProviders.contains(clazz)) continue;
                    if (this.hasEjbAndIsNotAManagedBean(restEjbs, clazz.getName())) {
                        this.deployEJB(webApp.contextRoot, appPrefix, restEjbs.get((Object)clazz.getName()).context, additionalProviders, appInfo.services);
                        continue;
                    }
                    pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                    this.deployPojo(webApp.contextRoot, appPrefix, clazz, appInstance, classLoader, injections, context, owbCtx, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)clazz.getName()), (Collection)appInfo.services));
                }
                useApp = useApp || classes.size() + singletons.size() > 0;
                LOGGER.info("REST application deployed: " + app);
            }
            if (!useApp) {
                if (webApp.restApplications.isEmpty() || webApp.restApplications.size() > 1) {
                    appPrefix = webApp.contextRoot;
                }
                HashSet restClasses = new HashSet(webApp.restClass);
                restClasses.addAll(webApp.ejbRestServices);
                for (String clazz : restClasses) {
                    if (restEjbs.containsKey(clazz)) {
                        BeanContext ctx = restEjbs.get((Object)clazz).context;
                        if (this.hasEjbAndIsNotAManagedBean(restEjbs, clazz)) {
                            this.deployEJB(webApp.contextRoot, appPrefix, restEjbs.get((Object)clazz).context, additionalProviders, appInfo.services);
                            continue;
                        }
                        this.deployPojo(webApp.contextRoot, appPrefix, ctx.getBeanClass(), null, ctx.getClassLoader(), ctx.getInjections(), context, owbCtx, additionalProviders, new ServiceConfiguration(ctx.getProperties(), (Collection)appInfo.services));
                        continue;
                    }
                    try {
                        Class<?> loadedClazz = classLoader.loadClass(clazz);
                        pojoConfigurations = PojoUtil.findPojoConfig(pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                        this.deployPojo(webApp.contextRoot, appPrefix, loadedClazz, null, classLoader, injections, context, owbCtx, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)loadedClazz.getName()), (Collection)appInfo.services));
                    }
                    catch (ClassNotFoundException e) {
                        throw new OpenEJBRestRuntimeException("can't find class " + clazz, e);
                    }
                }
            }
            restEjbs.clear();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private static <T> boolean isProvider(Class<T> clazz) {
        return new MetaAnnotatedClass(clazz).isAnnotationPresent(Provider.class);
    }

    private boolean hasEjbAndIsNotAManagedBean(Map<String, EJBRestServiceInfo> restEjbs, String clazz) {
        return restEjbs.containsKey(clazz) && !BeanType.MANAGED.equals((Object)restEjbs.get((Object)clazz).context.getComponentType());
    }

    private boolean useDiscoveredProviders() {
        return SystemInstance.get().getOptions().get(OPENEJB_JAXRS_PROVIDERS_AUTO_PROP, false);
    }

    private Collection<Object> appProviders(AppInfo appInfo, ClassLoader classLoader) {
        HashSet<Object> additionalProviders = new HashSet<Object>();
        for (String name : appInfo.jaxRsProviders) {
            try {
                additionalProviders.add(classLoader.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("can't load '" + name + "'", (Throwable)e);
            }
        }
        return additionalProviders;
    }

    public void afterApplicationCreated(@Observes AssemblerAfterApplicationCreated event) {
        if (!this.enabled) {
            return;
        }
        AppInfo appInfo = event.getApp();
        if (this.deployedApplications.add(appInfo)) {
            if (appInfo.webApps.size() == 0) {
                Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo);
                Collection<Object> providers = this.useDiscoveredProviders() ? this.appProviders(appInfo, this.containerSystem.getAppContext((Object)appInfo.appId).getClassLoader()) : new ArrayList();
                for (Map.Entry<String, EJBRestServiceInfo> ejb : restEjbs.entrySet()) {
                    BeanContext ctx = ejb.getValue().context;
                    if (BeanType.MANAGED.equals((Object)ctx.getComponentType())) {
                        this.deployPojo("", ejb.getValue().path, ctx.getBeanClass(), null, ctx.getClassLoader(), ctx.getInjections(), ctx.getJndiContext(), this.containerSystem.getAppContext((Object)appInfo.appId).getWebBeansContext(), providers, new ServiceConfiguration(ctx.getProperties(), (Collection)appInfo.services));
                        continue;
                    }
                    this.deployEJB("", ejb.getValue().path, ctx, providers, appInfo.services);
                }
                restEjbs.clear();
            } else {
                for (WebAppInfo webApp : appInfo.webApps) {
                    this.afterApplicationCreated(appInfo, webApp);
                }
            }
        }
    }

    protected Map<String, EJBRestServiceInfo> getRestEjbs(AppInfo appInfo) {
        HashMap<String, BeanContext> beanContexts = new HashMap<String, BeanContext>();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                BeanContext beanContext;
                if (!bean.restService || (beanContext = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId)) == null) continue;
                beanContexts.put(bean.ejbClass, beanContext);
            }
        }
        HashMap<String, EJBRestServiceInfo> restEjbs = new HashMap<String, EJBRestServiceInfo>();
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            for (String ejb : webAppInfo.ejbRestServices) {
                restEjbs.put(ejb, new EJBRestServiceInfo(webAppInfo.contextRoot, (BeanContext)beanContexts.get(ejb)));
            }
        }
        for (Map.Entry entry : beanContexts.entrySet()) {
            String clazz = (String)entry.getKey();
            if (restEjbs.containsKey(clazz)) continue;
            String context = null;
            if (!OLD_WEBSERVICE_DEPLOYMENT) {
                context = appInfo.appId != null && !appInfo.appId.isEmpty() ? appInfo.appId : ((BeanContext)entry.getValue()).getModuleName();
            }
            restEjbs.put(clazz, new EJBRestServiceInfo(context, (BeanContext)beanContexts.get(clazz)));
        }
        beanContexts.clear();
        return restEjbs;
    }

    private void deploySingleton(String web, String contextRoot, Object o, Application appInstance, ClassLoader classLoader, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        String nopath = this.getAddress(contextRoot, o.getClass());
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(web, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(new DeployedService(address.complete, web, o.getClass().getName()));
        listener.deploySingleton(RESTService.getFullContext(address.base, contextRoot), o, appInstance, additionalProviders, configuration);
        LOGGER.info("deployed REST singleton: " + o);
    }

    private void deployPojo(String web, String contextRoot, Class<?> loadedClazz, Application app, ClassLoader classLoader, Collection<Injection> injections, Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration config) {
        if (loadedClazz.isInterface()) {
            return;
        }
        String nopath = this.getAddress(contextRoot, loadedClazz);
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(web, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(new DeployedService(address.complete, contextRoot, loadedClazz.getName()));
        listener.deployPojo(RESTService.getFullContext(address.base, contextRoot), loadedClazz, app, injections, context, owbCtx, additionalProviders, config);
        LOGGER.info("REST Service: " + address.complete + "  -> Pojo " + loadedClazz.getName());
    }

    private void deployEJB(String web, String context, BeanContext beanContext, Collection<Object> additionalProviders, Collection<ServiceInfo> serviceInfos) {
        String nopath = this.getAddress(context, beanContext.getBeanClass());
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(web, listener, beanContext.getClassLoader(), nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost);
        this.services.add(new DeployedService(address.complete, context, beanContext.getBeanClass().getName()));
        listener.deployEJB(RESTService.getFullContext(address.base, context), beanContext, additionalProviders, new ServiceConfiguration(beanContext.getProperties(), serviceInfos));
        LOGGER.info("REST Service: " + address.complete + "  -> EJB " + beanContext.getEjbName());
    }

    protected abstract RsHttpListener createHttpListener();

    private static String getFullContext(String address, String context) {
        if (context == null) {
            return address;
        }
        if (context.isEmpty() && address.contains("/")) {
            return address.substring(0, address.lastIndexOf("/"));
        }
        String webCtx = context;
        while (webCtx.startsWith("/")) {
            webCtx = webCtx.substring(1);
        }
        try {
            URL url = new URL(address);
            int port = url.getPort();
            if (port > 0) {
                return url.getProtocol() + "://" + url.getHost() + ":" + port + "/" + webCtx;
            }
            return url.getProtocol() + "://" + url.getHost() + "/" + webCtx;
        }
        catch (MalformedURLException e) {
            throw new OpenEJBRestRuntimeException("bad url: " + address, e);
        }
    }

    private Class<?> findPath(Class<?> clazz) {
        Class<?> usedClass = clazz;
        while (usedClass.getAnnotation(Path.class) == null && usedClass.getSuperclass() != null) {
            usedClass = usedClass.getSuperclass();
        }
        return usedClass;
    }

    private String getAddress(String context, Class<?> clazz) {
        Class<?>[] itfs;
        Class<?> usedClass;
        String root = NOPATH_PREFIX;
        if (context != null) {
            root = context.startsWith("/") ? root + context.substring(1) : root + context;
        }
        if (((usedClass = this.findPath(clazz)) == null || Object.class.equals(usedClass)) && (itfs = clazz.getInterfaces()) != null) {
            Class<?> c;
            Class<?>[] arr$ = itfs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (usedClass = this.findPath(c = arr$[i$])).getAnnotation(Path.class) == null; ++i$) {
            }
        }
        if (usedClass == null || usedClass.getAnnotation(Path.class) == null) {
            throw new IllegalArgumentException("no @Path annotation on " + clazz.getName());
        }
        String builtUrl = null;
        try {
            builtUrl = UriBuilder.fromUri((URI)new URI(root)).path(usedClass).build(new Object[0]).toURL().toString();
            return this.replaceParams(builtUrl);
        }
        catch (IllegalArgumentException iae) {
            if (builtUrl != null) {
                return builtUrl;
            }
            for (Class<?> current = usedClass; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
                Path path = current.getAnnotation(Path.class);
                if (path == null) continue;
                String classPath = path.value();
                if (classPath.startsWith("/")) {
                    classPath = classPath.substring(1);
                }
                if (!root.endsWith("/")) {
                    root = root + "/";
                }
                return this.replaceParams(root + classPath);
            }
            throw new OpenEJBRestRuntimeException("can't built the service mapping for service '" + usedClass.getName() + "'", iae);
        }
        catch (MalformedURLException e) {
            throw new OpenEJBRestRuntimeException("url is malformed", e);
        }
        catch (URISyntaxException e) {
            throw new OpenEJBRestRuntimeException("uri syntax is not correct", e);
        }
    }

    private String replaceParams(String url) {
        String managedUrl = url.replaceAll("\\{[^}]*\\}.*", this.wildcard);
        if (managedUrl.endsWith(this.wildcard)) {
            return managedUrl;
        }
        return managedUrl + "/" + this.wildcard;
    }

    private void undeployRestObject(String context) {
        HttpListener listener = this.rsRegistry.removeListener(context);
        if (listener != null) {
            ((RsHttpListener)RsHttpListener.class.cast(listener)).undeploy();
        }
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = RESTService.class.getClassLoader();
        }
        return cl;
    }

    public void beforeApplicationDestroyed(@Observes AssemblerBeforeApplicationDestroyed event) {
        AppInfo app = event.getApp();
        if (this.deployedApplications.contains(app)) {
            for (WebAppInfo webApp : app.webApps) {
                ArrayList<DeployedService> toRemove = new ArrayList<DeployedService>();
                for (DeployedService service : this.services) {
                    if (!service.isInWebApp(webApp)) continue;
                    this.undeployRestObject(service.address);
                    toRemove.add(service);
                }
                this.services.removeAll(toRemove);
                this.deployedWebApps.remove(webApp);
            }
        }
    }

    public void start() throws ServiceException {
        SystemInstance.get().setComponent(RESTService.class, (Object)this);
        this.beforeStart();
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        if (this.assembler != null) {
            SystemInstance.get().addObserver((Object)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                this.afterApplicationCreated(new AssemblerAfterApplicationCreated(appInfo));
            }
        }
    }

    protected void beforeStart() {
        this.rsRegistry = (RsRegistry)SystemInstance.get().getComponent(RsRegistry.class);
        if (this.rsRegistry == null && SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
            this.rsRegistry = new RsRegistryImpl();
        }
    }

    public void stop() throws ServiceException {
        if (this.assembler != null) {
            SystemInstance.get().removeObserver((Object)this);
            for (AppInfo appInfo : new ArrayList<AppInfo>(this.deployedApplications)) {
                this.beforeApplicationDestroyed(new AssemblerBeforeApplicationDestroyed(appInfo));
            }
        }
        for (DeployedService service : this.services) {
            this.undeployRestObject(service.address);
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public String getIP() {
        return IP;
    }

    public int getPort() {
        return -1;
    }

    public void init(Properties props) throws Exception {
        this.virtualHost = props.getProperty("virtualHost");
        this.enabled = ServiceManager.isEnabled((Properties)props);
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public List<DeployedService> getServices() {
        return this.services;
    }

    public static class DeployedService {
        public String address;
        public String webapp;
        public String origin;

        public DeployedService(String address, String webapp, String origin) {
            this.address = address;
            this.webapp = webapp;
            this.origin = origin;
        }

        public boolean isInWebApp(WebAppInfo webApp) {
            return webApp.contextRoot == this.webapp || this.webapp != null && this.webapp.startsWith(webApp.contextRoot);
        }
    }

    public static class EJBRestServiceInfo {
        public String path;
        public BeanContext context;

        public EJBRestServiceInfo(String path, BeanContext context) {
            if (context == null) {
                throw new OpenEJBRestRuntimeException("can't find context");
            }
            this.path = path;
            this.context = context;
        }
    }
}

