/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryRegistry;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceAccessController;
import org.apache.openejb.server.ServiceDaemon;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceLogger;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.SimpleServiceManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceManager {
    static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, (String)"org.apache.openejb.server.util.resources");
    private static ServiceManager manager;

    public static ServiceManager getManager() {
        if (manager == null) {
            manager = new SimpleServiceManager();
        }
        return manager;
    }

    public static ServiceManager get() {
        return manager;
    }

    protected static void setServiceManager(ServiceManager newManager) {
        manager = newManager;
    }

    protected List<ServerService> initServers(Map<String, Properties> availableServices) throws IOException {
        ArrayList<ServerService> enabledServers = new ArrayList<ServerService>();
        for (Map.Entry<String, Properties> entry : availableServices.entrySet()) {
            Properties serviceProperties;
            String serviceName = entry.getKey();
            ServerService service = this.initServer(serviceName, serviceProperties = entry.getValue());
            if (service == null) continue;
            enabledServers.add(service);
        }
        return enabledServers;
    }

    protected ServerService initServer(String serviceName, Properties serviceProperties) throws IOException {
        DiscoveryRegistry registry = (DiscoveryRegistry)SystemInstance.get().getComponent(DiscoveryRegistry.class);
        OpenEjbConfiguration conf = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        logger.debug("Processing ServerService(id=" + serviceName + ")");
        this.overrideProperties(serviceName, serviceProperties);
        serviceProperties.setProperty("name", serviceName);
        if (conf != null && conf.facilities != null) {
            ServiceInfo info = new ServiceInfo();
            info.className = ((Class)serviceProperties.get(ServerService.class)).getName();
            info.service = "ServerService";
            info.id = serviceName;
            info.properties = serviceProperties;
            conf.facilities.services.add(info);
        }
        boolean enabled = this.isEnabled(serviceProperties);
        logger.debug("Found ServerService(id=" + serviceName + ", disabled=" + !enabled + ")");
        if (enabled) {
            Class serviceClass = (Class)serviceProperties.get(ServerService.class);
            logger.info("Creating ServerService(id=" + serviceName + ")");
            if (logger.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : serviceProperties.entrySet()) {
                    logger.debug(entry.getKey() + " = " + entry.getValue());
                }
            }
            try {
                ServerService service = null;
                ObjectRecipe recipe = new ObjectRecipe(serviceClass);
                try {
                    if (ReflectionUtil.findStaticFactory((Class)serviceClass, (String)"createServerService", null, null) != null) {
                        recipe = new ObjectRecipe(serviceClass, "createServerService");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                service = (ServerService)recipe.create(serviceClass.getClassLoader());
                if (!(service instanceof SelfManaging)) {
                    service = new ServicePool(service, serviceName, serviceProperties);
                    service = new ServiceLogger(service);
                    service = new ServiceAccessController(service);
                    service = new ServiceDaemon(service);
                }
                service.init(serviceProperties);
                if (service instanceof DiscoveryAgent) {
                    DiscoveryAgent agent = (DiscoveryAgent)((Object)service);
                    registry.addDiscoveryAgent(agent);
                }
                return service;
            }
            catch (Throwable t) {
                logger.error("service.instantiation.err", t, new Object[]{serviceClass.getName(), t.getClass().getName(), t.getMessage()});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overrideProperties(String serviceName, Properties serviceProperties) throws IOException {
        FileUtils base = SystemInstance.get().getBase();
        File conf = base.getDirectory("conf");
        if (conf.exists()) {
            File serviceConfig = new File(conf, serviceName + ".properties");
            if (serviceConfig.exists()) {
                FileInputStream in = new FileInputStream(serviceConfig);
                try {
                    serviceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            FileOutputStream out = new FileOutputStream(serviceConfig);
            try {
                String rawPropsContent = (String)serviceProperties.get(Properties.class);
                out.write(rawPropsContent.getBytes());
            }
            finally {
                out.close();
            }
        }
        String prefix = serviceName + ".";
        Properties sysProps = new Properties(System.getProperties());
        sysProps.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        for (Map.Entry<Object, Object> entry1 : sysProps.entrySet()) {
            String key = (String)entry1.getKey();
            Object value = entry1.getValue();
            if (!(value instanceof String) || !key.startsWith(prefix)) continue;
            key = key.replaceFirst(prefix, "");
            serviceProperties.setProperty(key, (String)value);
        }
    }

    private boolean isEnabled(Properties props) {
        String disabled = props.getProperty("disabled", "");
        return !disabled.equalsIgnoreCase("yes") && !disabled.equalsIgnoreCase("true");
    }

    public abstract void init() throws Exception;

    public void start() throws ServiceException {
        this.start(true);
    }

    public abstract void start(boolean var1) throws ServiceException;

    public abstract void stop() throws ServiceException;
}

