/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.auth;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.server.auth.IPAddressPermission;

public class FactorizedIPAddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^((\\d{1,3}){1}(\\.\\d{1,3}){0,2}\\.)?\\{(\\d{1,3}){1}((,\\d{1,3})*)\\}$");
    private final byte[] prefixBytes;
    private final byte[] suffixBytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public FactorizedIPAddressPermission(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        String prefix = matcher.group(1);
        StringTokenizer tokenizer = new StringTokenizer(prefix, ".");
        this.prefixBytes = new byte[tokenizer.countTokens()];
        for (int i = 0; i < this.prefixBytes.length; ++i) {
            String token = tokenizer.nextToken();
            int value = Integer.parseInt(token);
            if (value < 0 || 255 < value) {
                throw new IllegalArgumentException("byte #" + i + " is not valid.");
            }
            this.prefixBytes[i] = (byte)value;
        }
        String suffix = matcher.group(5);
        tokenizer = new StringTokenizer(suffix, ",");
        this.suffixBytes = new byte[1 + tokenizer.countTokens()];
        int value = Integer.parseInt(matcher.group(4));
        int i = 0;
        if (value < 0 || 255 < value) {
            throw new IllegalArgumentException("suffix " + i + " is not valid.");
        }
        this.suffixBytes[i++] = (byte)value;
        while (i < this.suffixBytes.length) {
            String token = tokenizer.nextToken();
            value = Integer.parseInt(token);
            if (value < 0 || 255 < value) {
                throw new IllegalArgumentException("byte #" + i + " is not valid.");
            }
            this.suffixBytes[i] = (byte)value;
            ++i;
        }
    }

    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < this.prefixBytes.length; ++i) {
            if (byteAddress[i] == this.prefixBytes[i]) continue;
            return false;
        }
        byte lastByte = byteAddress[this.prefixBytes.length];
        for (int i = 0; i < this.suffixBytes.length; ++i) {
            if (lastByte != this.suffixBytes[i]) continue;
            return true;
        }
        return false;
    }
}

