/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.auth;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.server.auth.IPAddressPermission;

public class NetmaskIPAddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/((\\d{1,2})|(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3}))$");
    private final byte[] networkAddressBytes;
    private final byte[] netmaskBytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public NetmaskIPAddressPermission(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        this.networkAddressBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            String group = matcher.group(i + 1);
            int value = Integer.parseInt(group);
            if (value < 0 || 255 < value) {
                throw new IllegalArgumentException("byte #" + i + " is not valid.");
            }
            this.networkAddressBytes[i] = (byte)value;
        }
        this.netmaskBytes = new byte[4];
        String netmask = matcher.group(6);
        if (null != netmask) {
            int value = Integer.parseInt(netmask);
            int pos = value / 8;
            int shift = 8 - value % 8;
            for (int i = 0; i < pos; ++i) {
                this.netmaskBytes[i] = -1;
            }
            this.netmaskBytes[pos] = (byte)(255 << shift);
        } else {
            for (int i = 0; i < 4; ++i) {
                String group = matcher.group(i + 7);
                int value = Integer.parseInt(group);
                if (value < 0 || 255 < value) {
                    throw new IllegalArgumentException("byte #" + i + " is not valid.");
                }
                this.netmaskBytes[i] = (byte)value;
            }
        }
    }

    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < 4; ++i) {
            if ((this.netmaskBytes[i] & byteAddress[i]) == this.networkAddressBytes[i]) continue;
            return false;
        }
        return true;
    }
}

