/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import javax.security.auth.login.LoginException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Base64;

public class BasicAuthHttpListenerWrapper
implements HttpListener {
    private HttpListener httpListener;
    private String realmName;

    public BasicAuthHttpListenerWrapper(HttpListener httpListener, String realmName) {
        this.httpListener = httpListener;
        this.realmName = realmName;
    }

    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        String decoded;
        String[] parts;
        Object token = null;
        String auth = request.getHeader("Authorization");
        if (auth != null && auth.length() > 0 && auth.toUpperCase().startsWith("BASIC ") && (parts = (decoded = new String(Base64.decodeBase64((byte[])(auth = auth.substring(6)).getBytes()))).split(":")) != null && parts.length == 2) {
            String username = parts[0];
            String password = parts[1];
            try {
                SecurityService securityService = this.getSecurityService();
                token = securityService.login(this.realmName, username, password);
                if (token != null) {
                    securityService.associate(token);
                }
            }
            catch (LoginException e) {
                // empty catch block
            }
        }
        if (token != null || HttpRequest.Method.GET == request.getMethod()) {
            this.httpListener.onMessage(request, response);
        }
        if (token != null) {
            this.getSecurityService().disassociate();
        }
    }

    private SecurityService getSecurityService() {
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        return securityService;
    }
}

