/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpServerFactory;
import org.apache.openejb.server.webservices.BasicAuthHttpListenerWrapper;
import org.apache.openejb.server.webservices.WsRegistry;
import org.apache.openejb.server.webservices.WsService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenEJBHttpWsRegistry
implements WsRegistry {
    public static final Logger log = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, WsService.class);
    private final HttpListenerRegistry registry;
    private final List<URI> baseUris = new ArrayList<URI>();

    public OpenEJBHttpWsRegistry() {
        try {
            OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            for (ServiceInfo service : configuration.facilities.services) {
                if (!service.className.equals(HttpServerFactory.class.getName())) continue;
                int port = Integer.parseInt(service.properties.getProperty("port"));
                String ip = service.properties.getProperty("bind");
                if ("0.0.0.0".equals(ip)) {
                    InetAddress[] addresses;
                    for (InetAddress address : addresses = InetAddress.getAllByName(ip)) {
                        this.baseUris.add(new URI("http", null, address.getHostAddress(), port, null, null, null));
                    }
                } else {
                    this.baseUris.add(new URI("http", null, ip, port, null, null, null));
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Webservices Disabled: Unable to build base URIs for WebService registry", (Throwable)e);
        }
        this.registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
    }

    @Override
    public List<String> setWsContainer(String virtualHost, String contextRoot, String servletName, HttpListener wsContainer) throws Exception {
        throw new UnsupportedOperationException("OpenEJB http server does not support POJO webservices");
    }

    @Override
    public void clearWsContainer(String virtualHost, String contextRoot, String servletName) {
    }

    @Override
    public List<String> addWsContainer(String path, HttpListener httpListener, String virtualHost, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (httpListener == null) {
            throw new NullPointerException("httpListener is null");
        }
        if ("BASIC".equals(authMethod)) {
            httpListener = new BasicAuthHttpListenerWrapper(httpListener, realmName);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        httpListener = new ClassLoaderHttpListener(httpListener, classLoader);
        this.registry.addHttpListener(httpListener, path);
        ArrayList<String> addresses = new ArrayList<String>();
        for (URI baseUri : this.baseUris) {
            URI address = baseUri.resolve(path);
            addresses.add(address.toString());
        }
        return addresses;
    }

    @Override
    public void removeWsContainer(String path) {
        this.registry.removeHttpListener(path);
    }

    private static class ClassLoaderHttpListener
    implements HttpListener {
        private final HttpListener delegate;
        private final ClassLoader classLoader;

        private ClassLoaderHttpListener(HttpListener delegate, ClassLoader classLoader) {
            this.delegate = delegate;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.delegate.onMessage(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }
}

