/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices.saaj;

import java.util.LinkedList;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SaajUniverse {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, SaajUniverse.class);
    public static final Type DEFAULT;
    public static final Type SUN;
    public static final Type AXIS1;
    public static final Type AXIS2;
    private static final ThreadLocal<LinkedList<Type>> currentUniverse;

    private static void setProperty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    public void set(Type newUniverse) {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList == null) {
            universeList = new LinkedList();
            currentUniverse.set(universeList);
        }
        universeList.add(newUniverse);
        if (logger.isDebugEnabled()) {
            logger.debug("Set universe: " + Thread.currentThread() + " " + (Object)((Object)newUniverse));
        }
    }

    public void unset() {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList != null && !universeList.isEmpty()) {
            universeList.removeLast();
            if (logger.isDebugEnabled()) {
                logger.debug("Restored universe: " + Thread.currentThread());
            }
        }
    }

    static Type getCurrentUniverse() {
        LinkedList<Type> universeList = currentUniverse.get();
        if (universeList != null && !universeList.isEmpty()) {
            return universeList.getLast();
        }
        return null;
    }

    static {
        SaajUniverse.setProperty("javax.xml.soap.MessageFactory", "org.apache.openejb.server.webservices.saaj.MessageFactoryImpl");
        SaajUniverse.setProperty("javax.xml.soap.SOAPFactory", "org.apache.openejb.server.webservices.saaj.SoapFactoryImpl");
        SaajUniverse.setProperty("javax.xml.soap.SOAPConnectionFactory", "org.apache.openejb.server.webservices.saaj.SoapConnectionFactoryImpl");
        SaajUniverse.setProperty("javax.xml.soap.MetaFactory", "org.apache.openejb.server.webservices.saaj.SaajMetaFactoryImpl");
        DEFAULT = Type.DEFAULT;
        SUN = Type.SUN;
        AXIS1 = Type.AXIS1;
        AXIS2 = Type.AXIS2;
        currentUniverse = new InheritableThreadLocal<LinkedList<Type>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        DEFAULT,
        AXIS1,
        AXIS2,
        SUN;

    }
}

