/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.PortInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.SingletonBeanInfo;
import org.apache.openejb.assembler.classic.StatelessBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.WsBuilder;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.webservices.PortAddressRegistry;
import org.apache.openejb.core.webservices.PortAddressRegistryImpl;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.webservices.OpenEJBHttpWsRegistry;
import org.apache.openejb.server.webservices.WsRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;

public abstract class WsService
implements ServerService,
SelfManaging,
DeploymentListener {
    public static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, WsService.class);
    public static final String WS_ADDRESS_FORMAT = "openejb.wsAddress.format";
    public static final String WS_FORCE_ADDRESS = "openejb.webservice.deployment.address";
    private static final boolean OLD_WEBSERVICE_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false);
    private StringTemplate wsAddressTemplate;
    private PortAddressRegistry portAddressRegistry;
    private CoreContainerSystem containerSystem;
    private Assembler assembler;
    private WsRegistry wsRegistry;
    private String realmName;
    private String transportGuarantee;
    private String authMethod;
    private String virtualHost;
    private final Set<AppInfo> deployedApplications = new HashSet<AppInfo>();
    private final Set<WebAppInfo> deployedWebApps = new HashSet<WebAppInfo>();
    private final Map<String, String> ejbLocations = new TreeMap<String, String>();
    private final Map<String, String> ejbAddresses = new TreeMap<String, String>();
    private final Map<String, String> servletAddresses = new TreeMap<String, String>();

    public WsService() {
        String format = SystemInstance.get().getOptions().get(WS_ADDRESS_FORMAT, "/{ejbDeploymentId}");
        this.wsAddressTemplate = new StringTemplate(format);
    }

    public StringTemplate getWsAddressTemplate() {
        return this.wsAddressTemplate;
    }

    public void setWsAddressTemplate(StringTemplate wsAddressTemplate) {
        this.wsAddressTemplate = wsAddressTemplate;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getIP() {
        return "n/a";
    }

    public int getPort() {
        return -1;
    }

    public void init(Properties props) throws Exception {
        if (props == null) {
            return;
        }
        String format = props.getProperty(WS_ADDRESS_FORMAT);
        if (format != null) {
            this.wsAddressTemplate = new StringTemplate(format);
        }
        this.realmName = props.getProperty("realmName");
        this.transportGuarantee = props.getProperty("transportGuarantee");
        this.authMethod = props.getProperty("authMethod");
        this.virtualHost = props.getProperty("virtualHost");
    }

    public void start() throws ServiceException {
        this.wsRegistry = (WsRegistry)SystemInstance.get().getComponent(WsRegistry.class);
        if (this.wsRegistry == null && SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
            this.wsRegistry = new OpenEJBHttpWsRegistry();
        }
        if (this.portAddressRegistry == null) {
            this.portAddressRegistry = new PortAddressRegistryImpl();
            SystemInstance.get().setComponent(PortAddressRegistry.class, (Object)this.portAddressRegistry);
        }
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.portAddressRegistry = (PortAddressRegistry)SystemInstance.get().getComponent(PortAddressRegistry.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        SystemInstance.get().setComponent(WsService.class, (Object)this);
        if (this.assembler != null) {
            this.assembler.addDeploymentListener((DeploymentListener)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                this.afterApplicationCreated(appInfo);
            }
        }
    }

    public void stop() throws ServiceException {
        if (this.assembler != null) {
            this.assembler.removeDeploymentListener((DeploymentListener)this);
            for (AppInfo appInfo : new ArrayList<AppInfo>(this.deployedApplications)) {
                this.beforeApplicationDestroyed(appInfo);
            }
            this.assembler = null;
            if (SystemInstance.get().getComponent(WsService.class) == this) {
                SystemInstance.get().removeComponent(WsService.class);
            }
        }
    }

    protected abstract HttpListener createEjbWsContainer(URL var1, PortData var2, BeanContext var3) throws Exception;

    protected abstract void destroyEjbWsContainer(String var1);

    protected abstract HttpListener createPojoWsContainer(URL var1, PortData var2, String var3, Class var4, Context var5, String var6) throws Exception;

    protected abstract void destroyPojoWsContainer(String var1);

    public void afterApplicationCreated(AppInfo appInfo) {
        if (this.deployedApplications.add(appInfo)) {
            HashMap<String, String> webContextByEjb = new HashMap<String, String>();
            for (WebAppInfo webApp : appInfo.webApps) {
                for (String ejb : webApp.ejbWebServices) {
                    webContextByEjb.put(ejb, webApp.contextRoot);
                }
            }
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("appId", appInfo.path);
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                TreeMap<String, PortInfo> ports = new TreeMap<String, PortInfo>();
                for (PortInfo port : ejbJar.portInfos) {
                    ports.put(port.serviceLink, port);
                }
                URL moduleBaseUrl = null;
                if (ejbJar.path != null) {
                    try {
                        moduleBaseUrl = new File(ejbJar.path).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        logger.error("Invalid ejb jar location " + ejbJar.path, (Throwable)e);
                    }
                }
                StringTemplate deploymentIdTemplate = this.wsAddressTemplate;
                if (ejbJar.properties.containsKey(WS_ADDRESS_FORMAT)) {
                    String format = ejbJar.properties.getProperty(WS_ADDRESS_FORMAT);
                    logger.info("Using openejb.wsAddress.format '" + format + "'");
                    deploymentIdTemplate = new StringTemplate(format);
                }
                contextData.put("ejbJarId", ejbJar.moduleName);
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    PortInfo portInfo;
                    BeanContext beanContext;
                    if (!(bean instanceof StatelessBeanInfo) && !(bean instanceof SingletonBeanInfo) || (beanContext = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId)) == null || (portInfo = (PortInfo)ports.get(bean.ejbName)) == null) continue;
                    try {
                        List<String> addresses;
                        String address;
                        String context;
                        PortData port = WsBuilder.toPortData((PortInfo)portInfo, (Collection)beanContext.getInjections(), (URL)moduleBaseUrl, (ClassLoader)beanContext.getClassLoader());
                        HttpListener container = this.createEjbWsContainer(moduleBaseUrl, port, beanContext);
                        String location = port.getLocation();
                        if (location == null) {
                            location = this.autoAssignWsLocation(bean, port, contextData, deploymentIdTemplate);
                        }
                        if (!location.startsWith("/")) {
                            location = "/" + location;
                        }
                        this.ejbLocations.put(bean.ejbDeploymentId, location);
                        ClassLoader classLoader = beanContext.getClassLoader();
                        if (this.wsRegistry == null) continue;
                        String auth = this.authMethod;
                        String realm = this.realmName;
                        String transport = this.transportGuarantee;
                        if ("BASIC".equals(portInfo.authMethod) || "DIGEST".equals(portInfo.authMethod) || "CLIENT-CERT".equals(portInfo.authMethod)) {
                            auth = portInfo.authMethod;
                            realm = portInfo.realmName;
                            transport = portInfo.transportGuarantee;
                        }
                        if ((context = (String)webContextByEjb.get(bean.ejbClass)) == null && !OLD_WEBSERVICE_DEPLOYMENT) {
                            context = ejbJar.moduleName;
                        }
                        if ((address = HttpUtil.selectSingleAddress(addresses = this.wsRegistry.addWsContainer(context, location, container, this.virtualHost, realm, transport, auth, classLoader))) == null) continue;
                        this.portAddressRegistry.addPort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.wsdlPort, portInfo.seiInterfaceName, address);
                        logger.info("Webservice(wsdl=" + address + ", qname=" + port.getWsdlService() + ") --> Ejb(id=" + portInfo.portId + ")");
                        this.ejbAddresses.put(bean.ejbDeploymentId, address);
                    }
                    catch (Throwable e) {
                        logger.error("Error deploying JAX-WS Web Service for EJB " + beanContext.getDeploymentID(), e);
                    }
                }
            }
            for (WebAppInfo webApp : appInfo.webApps) {
                this.afterApplicationCreated(webApp);
            }
        }
    }

    public void afterApplicationCreated(WebAppInfo webApp) {
        WebContext webContext = this.containerSystem.getWebContext(webApp.moduleId);
        if (webContext == null) {
            return;
        }
        if (!this.deployedWebApps.add(webApp)) {
            return;
        }
        TreeMap<String, PortInfo> ports = new TreeMap<String, PortInfo>();
        for (PortInfo port : webApp.portInfos) {
            ports.put(port.serviceLink, port);
        }
        URL moduleBaseUrl = null;
        try {
            moduleBaseUrl = new File(webApp.path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("Invalid ejb jar location " + webApp.path, (Throwable)e);
        }
        for (ServletInfo servlet : webApp.servlets) {
            PortInfo portInfo = (PortInfo)ports.get(servlet.servletName);
            if (portInfo == null) continue;
            try {
                ClassLoader classLoader = webContext.getClassLoader();
                Collection injections = webContext.getInjections();
                Context context = webContext.getJndiEnc();
                Class<?> target = classLoader.loadClass(servlet.servletClass);
                PortData port = WsBuilder.toPortData((PortInfo)portInfo, (Collection)injections, (URL)moduleBaseUrl, (ClassLoader)classLoader);
                HttpListener container = this.createPojoWsContainer(moduleBaseUrl, port, portInfo.serviceLink, target, context, webApp.contextRoot);
                if (this.wsRegistry == null) continue;
                List<String> addresses = this.wsRegistry.setWsContainer(this.virtualHost, webApp.contextRoot, servlet.servletName, container);
                String address = HttpUtil.selectSingleAddress(addresses);
                this.portAddressRegistry.addPort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId, portInfo.wsdlPort, portInfo.seiInterfaceName, address);
                logger.info("Webservice(wsdl=" + address + ", qname=" + port.getWsdlService() + ") --> Pojo(id=" + portInfo.portId + ")");
                this.servletAddresses.put(webApp.moduleId + "." + servlet.servletName, address);
            }
            catch (Throwable e) {
                logger.error("Error deploying CXF webservice for servlet " + portInfo.serviceLink, e);
            }
        }
    }

    public void beforeApplicationDestroyed(AppInfo appInfo) {
        if (this.deployedApplications.remove(appInfo)) {
            String address;
            PortInfo portInfo;
            TreeMap<String, PortInfo> ports;
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                ports = new TreeMap<String, PortInfo>();
                for (PortInfo port : ejbJar.portInfos) {
                    ports.put(port.serviceLink, port);
                }
                for (EnterpriseBeanInfo enterpriseBean : ejbJar.enterpriseBeans) {
                    if (!(enterpriseBean instanceof StatelessBeanInfo) && !(enterpriseBean instanceof SingletonBeanInfo) || (portInfo = (PortInfo)ports.get(enterpriseBean.ejbName)) == null) continue;
                    address = this.ejbAddresses.remove(enterpriseBean.ejbDeploymentId);
                    if (address != null) {
                        this.portAddressRegistry.removePort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId);
                    }
                    String location = this.ejbLocations.get(enterpriseBean.ejbDeploymentId);
                    if (this.wsRegistry != null && location != null) {
                        this.wsRegistry.removeWsContainer(location);
                    }
                    this.destroyEjbWsContainer(enterpriseBean.ejbDeploymentId);
                }
            }
            for (WebAppInfo webApp : appInfo.webApps) {
                this.deployedWebApps.remove(webApp);
                ports = new TreeMap();
                for (PortInfo port : webApp.portInfos) {
                    ports.put(port.serviceLink, port);
                }
                for (ServletInfo servlet : webApp.servlets) {
                    portInfo = (PortInfo)ports.get(servlet.servletClass);
                    if (portInfo == null) continue;
                    address = this.servletAddresses.remove(webApp.moduleId + "." + servlet.servletName);
                    if (address != null) {
                        this.portAddressRegistry.removePort(portInfo.serviceId, portInfo.wsdlService, portInfo.portId);
                    }
                    if (this.wsRegistry != null) {
                        this.wsRegistry.clearWsContainer(this.virtualHost, webApp.contextRoot, servlet.servletName);
                    }
                    this.destroyPojoWsContainer(portInfo.serviceLink);
                }
            }
        }
    }

    private String autoAssignWsLocation(EnterpriseBeanInfo bean, PortData port, Map<String, String> contextData, StringTemplate template) {
        if (bean.properties.containsKey(WS_FORCE_ADDRESS)) {
            return bean.properties.getProperty(WS_FORCE_ADDRESS);
        }
        contextData.put("ejbDeploymentId", bean.ejbDeploymentId);
        contextData.put("ejbType", WsService.getEjbType(bean.type));
        contextData.put("ejbClass", bean.ejbClass);
        contextData.put("ejbClass.simpleName", bean.ejbClass.substring(bean.ejbClass.lastIndexOf(46) + 1));
        contextData.put("ejbName", bean.ejbName);
        contextData.put("portComponentName", port.getPortName().getLocalPart());
        contextData.put("wsdlPort", port.getWsdlPort().getLocalPart());
        contextData.put("wsdlService", port.getWsdlService().getLocalPart());
        return template.apply(contextData);
    }

    public static String getEjbType(int type) {
        if (type == 1) {
            return "StatefulBean";
        }
        if (type == 2) {
            return "StatelessBean";
        }
        if (type == 4) {
            return "SingletonBean";
        }
        if (type == 5) {
            return "ManagedBean";
        }
        if (type == 3) {
            return "MessageDrivenBean";
        }
        if (type == 0) {
            return "StatefulBean";
        }
        return "UnknownBean";
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("CxfService cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException("CxfService cannot be invoked directly");
    }
}

