/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices.saaj;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

class SaajFactoryFinder {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_WS, SaajFactoryFinder.class);
    private static final String SAAJ_PROVIDER_PROPERTY = "org.apache.openejb.server.webservices.saaj.provider";
    private static SaajUniverse.Type DEFAULT_SAAJ_UNIVERSE = null;
    private static final Map<String, Map<String, String>> SAAJ_FACTORIES = new HashMap<String, Map<String, String>>();

    SaajFactoryFinder() {
    }

    private static void initDefaultSAAJProvider() {
        String provider = SystemInstance.get().getOptions().get(SAAJ_PROVIDER_PROPERTY, (String)null);
        if (provider != null) {
            if (provider.equalsIgnoreCase("axis2")) {
                DEFAULT_SAAJ_UNIVERSE = SaajUniverse.Type.AXIS2;
            } else if (provider.equalsIgnoreCase("sun")) {
                DEFAULT_SAAJ_UNIVERSE = SaajUniverse.Type.SUN;
            } else {
                throw new ServerRuntimeException("Invalid SAAJ universe specified: " + provider);
            }
            logger.info("Default SAAJ universe: " + (Object)((Object)DEFAULT_SAAJ_UNIVERSE));
        } else {
            logger.info("Default SAAJ universe not set");
        }
    }

    private static Map<String, String> createSAAJInfo(String messageFactory, String soapFactory, String soapConnectionFactory, String metaFactory) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.xml.soap.MessageFactory", messageFactory);
        map.put("javax.xml.soap.SOAPFactory", soapFactory);
        map.put("javax.xml.soap.SOAPConnectionFactory", soapConnectionFactory);
        map.put("javax.xml.soap.MetaFactory", metaFactory);
        return map;
    }

    static Object find(String factoryPropertyName) throws SOAPException {
        String factoryClassName = SaajFactoryFinder.getFactoryClass(factoryPropertyName);
        if (factoryClassName == null) {
            throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
        }
        return SaajFactoryFinder.newInstance(factoryClassName);
    }

    private static String getFactoryClass(String factoryName) {
        SaajUniverse.Type universe = SaajUniverse.getCurrentUniverse();
        if (universe == null || universe == SaajUniverse.Type.DEFAULT) {
            universe = DEFAULT_SAAJ_UNIVERSE == null ? (SaajFactoryFinder.isAxis2InClassLoader() ? SaajUniverse.Type.AXIS2 : SaajUniverse.Type.SUN) : DEFAULT_SAAJ_UNIVERSE;
        }
        return SAAJ_FACTORIES.get(universe.toString()).get(factoryName);
    }

    private static boolean isAxis2InClassLoader() {
        try {
            SaajFactoryFinder.loadClass("org.apache.axis2.saaj.MessageFactoryImpl");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    private static Object newInstance(String factoryClassName) throws SOAPException {
        try {
            Class<?> factory = null;
            try {
                factory = SaajFactoryFinder.loadClass(factoryClassName);
            }
            catch (ClassNotFoundException cnfe) {
                factory = SaajFactoryFinder.class.getClassLoader().loadClass(factoryClassName);
            }
            return factory.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SOAPException("Provider " + factoryClassName + " not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException("Provider " + factoryClassName + " could not be instantiated: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        SAAJ_FACTORIES.put(SaajUniverse.Type.AXIS1.toString(), SaajFactoryFinder.createSAAJInfo("org.apache.axis.soap.MessageFactoryImpl", "org.apache.axis.soap.SOAPFactoryImpl", "org.apache.axis.soap.SOAPConnectionFactoryImpl", "org.apache.axis.soap.SAAJMetaFactoryImpl"));
        SAAJ_FACTORIES.put(SaajUniverse.Type.AXIS2.toString(), SaajFactoryFinder.createSAAJInfo("org.apache.axis2.saaj.MessageFactoryImpl", "org.apache.axis2.saaj.SOAPFactoryImpl", "org.apache.axis2.saaj.SOAPConnectionFactoryImpl", "org.apache.axis2.saaj.SAAJMetaFactoryImpl"));
        SAAJ_FACTORIES.put(SaajUniverse.Type.SUN.toString(), SaajFactoryFinder.createSAAJInfo("com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl", "com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl"));
        SaajFactoryFinder.initDefaultSAAJProvider();
    }
}

