/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.config.ValidationException;
import org.apache.openejb.loader.Options;
import org.apache.openejb.tck.OpenEJBTCKRuntimeException;
import org.apache.openejb.tck.impl.AbstractContainers;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.Containers;

public class ContainersImplTomEE
extends AbstractContainers
implements Containers {
    private static int count = 0;
    private final RemoteServer server;
    private Deployer deployer = null;
    private Exception exception;
    private AppInfo appInfo;
    private File currentFile = null;

    private Deployer lookup() {
        Options options = new Options(System.getProperties());
        Properties props = new Properties();
        props.put("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        String port = System.getProperty("server.http.port");
        if (port == null) {
            throw new OpenEJBTCKRuntimeException("Please set the tomee port as a system property");
        }
        props.put("java.naming.provider.url", options.get("java.naming.provider.url", "http://localhost:" + port + "/tomee/ejb"));
        String deployerJndi = System.getProperty("openejb.deployer.jndiname", "openejb/DeployerBusinessRemote");
        try {
            InitialContext context = new InitialContext(props);
            return (Deployer)context.lookup(deployerJndi);
        }
        catch (Exception e) {
            throw new OpenEJBTCKRuntimeException(e);
        }
    }

    public ContainersImplTomEE() {
        System.out.println("ContainersImpl=" + ContainersImplTomEE.class.getName());
        System.out.println("Initialized ContainersImplTomEE " + ++count);
        this.server = new RemoteServer();
    }

    public boolean deploy(InputStream archive, String name) throws IOException {
        this.exception = null;
        this.appInfo = null;
        System.out.println("Deploying " + archive + " with name " + name);
        this.currentFile = this.getFile(name);
        System.out.println(this.currentFile);
        this.writeToFile(this.currentFile, archive);
        try {
            if (this.deployer == null) {
                this.deployer = this.lookup();
            }
            this.appInfo = this.deployer.deploy(this.currentFile.getAbsolutePath());
        }
        catch (Exception ex) {
            Exception e = ex;
            if (e.getCause() instanceof ValidationException) {
                e = (Exception)e.getCause();
            }
            if (name.contains(".broken.")) {
                this.exception = (DeploymentException)new DeploymentException("deploy failed").initCause((Throwable)e);
            } else {
                System.out.println("FIX Deployment of " + name);
                e.printStackTrace();
                this.exception = e;
            }
            return false;
        }
        return true;
    }

    public DeploymentException getDeploymentException() {
        try {
            return (DeploymentException)this.exception;
        }
        catch (Exception e) {
            System.out.println("BADCAST");
            return new DeploymentException("", (Throwable)this.exception);
        }
    }

    public void undeploy(String name) throws IOException {
        File toDelete;
        if (this.appInfo == null) {
            if (!(this.exception instanceof DeploymentException)) {
                System.out.println("Nothing to undeploy" + name);
            }
            return;
        }
        System.out.println("Undeploying " + name);
        try {
            this.deployer.undeploy(this.appInfo.path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OpenEJBTCKRuntimeException(e);
        }
        if (this.currentFile != null && (toDelete = this.currentFile.getParentFile()).exists()) {
            System.out.println("deleting " + toDelete.getAbsolutePath());
            ContainersImplTomEE.delete(toDelete);
        }
    }

    protected File getFile(String name) {
        File dir = new File(tmpDir, Math.random() + "");
        dir.mkdir();
        dir.deleteOnExit();
        return new File(dir, name);
    }

    public void setup() throws IOException {
        System.out.println("Setup called");
        this.server.start();
    }

    public void cleanup() throws IOException {
        System.out.println("Cleanup called");
        this.server.stop();
    }
}

