/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.Options;
import org.apache.openejb.tck.OpenEJBTCKRuntimeException;
import org.apache.openejb.tck.impl.AbstractContainers;
import org.apache.tomee.catalina.facade.ExceptionManagerFacade;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.Containers;

public class FullRestartContainer
extends AbstractContainers
implements Containers {
    private static final File WEBAPP_DIR = new File(System.getProperty("openejb.home"), "webapps/");
    private static final File APPS_DIR = new File(System.getProperty("openejb.home"), "apps/");
    private RemoteServer server;
    private Exception exception;
    private File currentFile;

    public FullRestartContainer() {
        System.out.println("ContainersImpl=" + FullRestartContainer.class.getName());
    }

    public DeploymentException getDeploymentException() {
        if (this.exception instanceof DeploymentException) {
            return (DeploymentException)this.exception;
        }
        System.out.println("BADCAST");
        return new DeploymentException("", (Throwable)this.exception);
    }

    public boolean deploy(InputStream archive, String name) throws IOException {
        this.currentFile = name.endsWith("war") ? new File(WEBAPP_DIR, name) : new File(APPS_DIR, name);
        System.out.println(this.currentFile);
        this.writeToFile(this.currentFile, archive);
        this.server = new RemoteServer(100, true);
        try {
            this.server.start();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        this.exception = this.lookup().exception();
        return this.exception == null;
    }

    public void undeploy(String name) throws IOException {
        this.server.destroy();
        File folder = new File(this.currentFile.getParentFile(), this.currentFile.getName().substring(0, this.currentFile.getName().length() - 4));
        if (folder.exists()) {
            FullRestartContainer.delete(folder);
        }
        FullRestartContainer.delete(this.currentFile);
    }

    public void setup() throws IOException {
    }

    public void cleanup() throws IOException {
    }

    private ExceptionManagerFacade lookup() {
        Options options = new Options(System.getProperties());
        Properties props = new Properties();
        props.put("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        String port = System.getProperty("server.http.port");
        if (port == null) {
            throw new OpenEJBTCKRuntimeException("Please set the tomee port as a system property");
        }
        System.out.println("provider url = http://localhost:" + port + "/tomee/ejb");
        props.put("java.naming.provider.url", options.get("java.naming.provider.url", "http://localhost:" + port + "/tomee/ejb"));
        try {
            InitialContext context = new InitialContext(props);
            return (ExceptionManagerFacade)context.lookup("openejb/ExceptionManagerFacadeBusinessRemote");
        }
        catch (Exception e) {
            throw new OpenEJBTCKRuntimeException(e);
        }
    }
}

