/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.tomee.catalina.LazyStopWebappLoader;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;
import org.apache.tomee.catalina.TomcatContextUtil;

public class LazyStopWebappClassLoader
extends WebappClassLoader {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)LazyStopWebappClassLoader.class.getName());
    public static final String TOMEE_WEBAPP_FIRST = "tomee.webapp-first";
    private boolean restarting = false;
    private volatile Context relatedContext;
    private boolean forceStopPhase = Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.webappclassloader.force-stop-phase", "false"));
    private ClassLoaderConfigurer configurer = null;

    public LazyStopWebappClassLoader() {
        this.construct();
    }

    public LazyStopWebappClassLoader(ClassLoader parent) {
        super(parent);
        this.construct();
    }

    private void construct() {
        this.setDelegate(LazyStopWebappClassLoader.isDelegate());
        this.configurer = ClassLoaderUtil.configurer((String)LazyStopWebappLoader.getCurrentAppId());
    }

    public void stop() throws LifecycleException {
        if (this.forceStopPhase && (this.restarting || TomcatContextUtil.isReloading(this.relatedContext))) {
            this.internalStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("org.apache.openejb.hibernate.OpenEJBJtaPlatform".equals(name) || "org.apache.openejb.jpa.integration.hibernate.PrefixNamingStrategy".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.PrefixSessionCustomizer".equals(name) || "org.apache.openejb.eclipselink.JTATransactionController".equals(name) || "org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            ClassLoader classLoader = this.system;
            synchronized (classLoader) {
                Class clazz;
                ClassLoader old = this.system;
                this.system = NoClassClassLoader.INSTANCE;
                try {
                    clazz = super.loadClass(name);
                    this.system = old;
                }
                catch (Throwable throwable) {
                    this.system = old;
                    throw throwable;
                }
                return clazz;
            }
        }
        if (URLClassLoaderFirst.shouldSkip((String)name)) {
            try {
                return OpenEJB.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name);
            }
            catch (NoClassDefFoundError ncdfe) {
                return super.loadClass(name);
            }
        }
        return super.loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalStop() throws LifecycleException {
        if (this.isStarted()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
            try {
                super.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public void restarting() {
        this.restarting = true;
    }

    public void restarted() {
        this.restarting = false;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.configurer != null) {
            URL[] enrichment;
            for (URL url : enrichment = this.configurer.additionalURLs()) {
                super.addURL(url);
            }
        }
        for (URL url : ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment((ClassLoader)((Object)this))) {
            super.addURL(url);
        }
    }

    public void addURL(URL url) {
        if (this.configurer == null || this.configurer.accept(url)) {
            super.addURL(url);
        }
    }

    protected boolean validateJarFile(File file) throws IOException {
        return super.validateJarFile(file) && TomEEClassLoaderEnricher.validateJarFile(file) && this.jarIsAccepted(file);
    }

    private boolean jarIsAccepted(File file) {
        if (this.configurer == null) {
            return true;
        }
        try {
            if (!this.configurer.accept(file.toURI().toURL())) {
                LOGGER.warning("jar '" + file.getAbsolutePath() + "' is excluded: " + file.getName() + ". It will be ignored.");
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return true;
    }

    public void setRelatedContext(Context standardContext) {
        this.relatedContext = standardContext;
    }

    public static boolean isDelegate() {
        return !SystemInstance.get().getOptions().get(TOMEE_WEBAPP_FIRST, true);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return URLClassLoaderFirst.filterResources((String)name, (Enumeration)super.getResources(name));
    }

    public String toString() {
        return "LazyStop" + super.toString();
    }

    private static class NoClassClassLoader
    extends ClassLoader {
        private static final NoClassClassLoader INSTANCE = new NoClassClassLoader();

        private NoClassClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }
    }
}

