/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.NamingException;
import org.apache.catalina.core.StandardContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.WebContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomee.catalina.InjectionFailedException;
import org.apache.webbeans.exception.WebBeansConfigurationException;

public class JavaeeInstanceManager
implements InstanceManager {
    private final WebContext webContext;
    private final StandardContext context;

    public JavaeeInstanceManager(WebContext webContext, StandardContext context) {
        this.webContext = webContext;
        this.context = context;
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ClassLoader classLoader = this.webContext.getClassLoader();
        return this.newInstance(className, classLoader);
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Object object = this.webContext.newInstance(clazz);
            this.postConstruct(object, clazz);
            return object;
        }
        catch (OpenEJBException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
        catch (WebBeansConfigurationException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
    }

    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        try {
            this.webContext.inject(o);
            this.postConstruct(o, o.getClass());
        }
        catch (OpenEJBException e) {
            throw new InjectionFailedException(e);
        }
    }

    public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return;
        }
        this.preDestroy(o, o.getClass());
        this.webContext.destroy(o);
    }

    public void inject(Object o) {
        try {
            this.webContext.inject(o);
        }
        catch (OpenEJBException e) {
            throw new InjectionFailedException(e);
        }
    }

    public void postConstruct(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.postConstruct(instance, superClass);
        }
        Method[] methods = clazz.getDeclaredMethods();
        AccessibleObject postConstruct = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct annotation. @PostConstruct methods should respect the following constraints:\n- no parameter (" + (method.getParameterTypes().length == 0) + ")\n" + "- no exception should be declared (" + (method.getExceptionTypes().length == 0) + ")\n" + "- should return void (" + method.getReturnType().getName().equals("void") + ")\n" + "- should not be static (" + !Modifier.isStatic(method.getModifiers()) + ")\n");
            }
            postConstruct = method;
        }
        if (postConstruct != null) {
            boolean accessibility = postConstruct.isAccessible();
            ((Method)postConstruct).setAccessible(true);
            ((Method)postConstruct).invoke(instance, new Object[0]);
            ((Method)postConstruct).setAccessible(accessibility);
        }
    }

    protected void preDestroy(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        Method[] methods = clazz.getDeclaredMethods();
        AccessibleObject preDestroy = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PreDestroy annotation");
            }
            preDestroy = method;
            break;
        }
        if (preDestroy != null) {
            boolean accessibility = preDestroy.isAccessible();
            ((Method)preDestroy).setAccessible(true);
            ((Method)preDestroy).invoke(instance, new Object[0]);
            ((Method)preDestroy).setAccessible(accessibility);
        }
    }
}

