/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.ws.rs.core.Application;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextConfig;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomee.catalina.OpenEJBNamingResource;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.common.ResourceFactory;

public class OpenEJBContextConfig
extends ContextConfig {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, OpenEJBContextConfig.class);
    private static final String MYFACES_TOMEEM_CONTAINER_INITIALIZER = "org.apache.tomee.myfaces.TomEEMyFacesContainerInitializer";
    private static final String TOMEE_MYFACES_CONTEXT_LISTENER = "org.apache.tomee.myfaces.TomEEMyFacesContextListener";
    private static final String ADJUST_DATASOURCE_JNDI_NAMES = SystemInstance.get().getProperty("tomee.resources.adjust-web-xml-jndi-name", "true");
    private TomcatWebAppBuilder.StandardContextInfo info;
    private boolean webInfClassesAnnotationsProcessed = false;

    public OpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        logger.debug("OpenEJBContextConfig({0})", new Object[]{standardContextInfo.toString()});
        this.info = standardContextInfo;
    }

    public void configureStart() {
        super.configureStart();
        this.adjustDataSourceNameIfNecessary();
        this.cleanUpRestServlets();
    }

    private void cleanUpRestServlets() {
        WebAppInfo webAppInfo = this.info.get();
        AppInfo appInfo = this.info.app();
        if (webAppInfo == null || appInfo == null || "false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
            return;
        }
        Container[] children = this.context.findChildren();
        HashMap<String, Container> mappedChildren = new HashMap<String, Container>();
        if (children != null) {
            for (Container c : children) {
                if (!(c instanceof StandardWrapper)) continue;
                StandardWrapper wrapper = (StandardWrapper)c;
                String appSpec = wrapper.getInitParameter("javax.ws.rs.Application");
                if (appSpec != null) {
                    mappedChildren.put(appSpec, c);
                    continue;
                }
                String app = wrapper.getInitParameter(Application.class.getName());
                if (app != null) {
                    mappedChildren.put(app, c);
                    continue;
                }
                if (wrapper.getServletClass() != null) continue;
                try {
                    if (!Application.class.isAssignableFrom(this.context.getLoader().getClassLoader().loadClass(wrapper.getServletName()))) continue;
                    this.context.removeChild(c);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String clazz : webAppInfo.restApplications) {
                Container child = (Container)mappedChildren.get(clazz);
                if (child == null) continue;
                this.context.removeChild(child);
            }
        }
    }

    protected void processAnnotationWebServlet(String className, AnnotationEntry ae, WebXml fragment) {
        try {
            super.processAnnotationWebServlet(className, ae, fragment);
        }
        catch (IllegalArgumentException iae) {
            String[] urlPatterns = null;
            for (ElementValuePair elementValuePair : ae.getElementValuePairs()) {
                String name = elementValuePair.getNameString();
                if (!"value".equals(name) && !"urlPatterns".equals(name)) continue;
                urlPatterns = this.processAnnotationsStringArray(elementValuePair.getValue());
                break;
            }
            if (urlPatterns != null) {
                for (ElementValuePair elementValuePair : urlPatterns) {
                    if (!fragment.getServletMappings().containsKey(elementValuePair)) continue;
                    logger.warning(iae.getMessage(), (Throwable)iae);
                    return;
                }
            }
            throw iae;
        }
    }

    protected void contextConfig(Digester digester) {
        NamingResources resources = this.context != null ? this.context.getNamingResources() : null;
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(true);
        }
        super.contextConfig(digester);
        if (resources instanceof OpenEJBNamingResource) {
            ((OpenEJBNamingResource)resources).setTomcatResource(false);
        }
    }

    private void adjustDataSourceNameIfNecessary() {
        if (this.context == null || "false".equalsIgnoreCase(ADJUST_DATASOURCE_JNDI_NAMES)) {
            return;
        }
        NamingResources resources = this.context.getNamingResources();
        if (resources == null) {
            return;
        }
        ContextResource[] foundResources = resources.findResources();
        String[] ids = null;
        if (foundResources != null) {
            for (ContextResource resource : foundResources) {
                if (!"javax.sql.DataSource".equals(resource.getType())) continue;
                String jndiName = (String)resource.getProperty("mappedName");
                if (jndiName == null) {
                    jndiName = resource.getName();
                }
                if (jndiName == null) continue;
                if (ids == null) {
                    Properties props = new Properties();
                    OpenEjbConfiguration runningConfig = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
                    ArrayList<String> resourceIds = new ArrayList<String>();
                    if (runningConfig != null) {
                        for (ResourceInfo resourceInfo : runningConfig.facilities.resources) {
                            if (!ConfigurationFactory.isResourceType((String)resourceInfo.service, (List)resourceInfo.types, (String)"javax.sql.DataSource") || !ServiceUtils.implies((Properties)props, (Properties)resourceInfo.properties)) continue;
                            resourceIds.add(resourceInfo.id);
                        }
                    }
                    ids = resourceIds.toArray(new String[resourceIds.size()]);
                }
                String mostMatchingId = null;
                for (void var13_17 : ids) {
                    if (var13_17.equals(jndiName)) {
                        mostMatchingId = jndiName;
                        break;
                    }
                    if (!jndiName.endsWith("/" + (String)var13_17) || mostMatchingId != null) continue;
                    mostMatchingId = var13_17;
                }
                if (mostMatchingId == null) continue;
                resource.setProperty("mappedName", (Object)("java:" + mostMatchingId));
                resource.setProperty("resourceid", (Object)("java:" + mostMatchingId));
                resource.setProperty("factory", (Object)ResourceFactory.class.getName());
            }
        }
    }

    protected WebXml createWebXml() {
        StandardContext standardContext;
        String prefix = "";
        if (this.context instanceof StandardContext && (prefix = (standardContext = (StandardContext)this.context).getEncodedPath()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        return new OpenEJBWebXml(prefix);
    }

    protected void webConfig() {
        super.webConfig();
        try {
            Class<?> myfacesInitializer = Class.forName(MYFACES_TOMEEM_CONTAINER_INITIALIZER, true, this.context.getLoader().getClassLoader());
            ServletContainerInitializer instance = (ServletContainerInitializer)myfacesInitializer.newInstance();
            this.context.addServletContainerInitializer(instance, this.getJsfClasses(this.context));
            this.context.addApplicationListener(TOMEE_MYFACES_CONTEXT_LISTENER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Set<Class<?>> getJsfClasses(Context context) {
        WebAppBuilder builder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        ClassLoader cl = context.getLoader().getClassLoader();
        Map scanned = (Map)builder.getJsfClasses().get(cl);
        if (scanned == null || scanned.isEmpty()) {
            return null;
        }
        HashSet classes = new HashSet();
        for (Set entry : scanned.values()) {
            for (String name : entry) {
                try {
                    classes.add(cl.loadClass(name));
                }
                catch (ClassNotFoundException ignored) {
                    logger.warning("class '" + name + "' was found but can't be loaded as a JSF class");
                }
            }
        }
        return classes;
    }

    protected void processServletContainerInitializers(Set<WebXml> fragments) {
        this.webInfClassesAnnotationsProcessed = false;
        try {
            super.processServletContainerInitializers(fragments);
        }
        catch (RuntimeException e) {
            this.webInfClassesAnnotationsProcessed = false;
            throw e;
        }
    }

    protected void processAnnotations(Set<WebXml> fragments, boolean handlesTypesOnly) {
        this.webInfClassesAnnotationsProcessed = false;
        super.processAnnotations(fragments, handlesTypesOnly);
    }

    protected void processAnnotationsFile(File file, WebXml fragment, boolean handlesTypesOnly) {
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsFile(file, fragment, handlesTypesOnly);
            return;
        }
        this.internalProcessAnnotations(file, webAppInfo, fragment, handlesTypesOnly);
    }

    protected void processAnnotationsUrl(URL currentUrl, WebXml fragment, boolean handlesTypeOnly) {
        File currentUrlAsFile;
        WebAppInfo webAppInfo = this.info.get();
        if (webAppInfo == null) {
            super.processAnnotationsUrl(currentUrl, fragment, handlesTypeOnly);
            return;
        }
        try {
            currentUrlAsFile = URLs.toFile((URL)currentUrl);
        }
        catch (IllegalArgumentException iae) {
            if ("jndi".equals(currentUrl.getProtocol())) {
                int idx;
                String path = webAppInfo.path;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                String file = currentUrl.getFile();
                String webAppDir = new File(path).getName();
                if ("ROOT".equals(webAppDir) && (webAppDir = webAppInfo.host) == null) {
                    webAppDir = "";
                }
                if ((idx = file.indexOf(webAppDir)) < 0) {
                    webAppDir = webAppInfo.moduleId;
                    idx = file.indexOf(webAppDir);
                }
                if (idx < 0) {
                    webAppDir = webAppInfo.contextRoot;
                    idx = file.indexOf(webAppDir);
                }
                if (idx > 0) {
                    String pathUnderWebapp = file.substring(idx + webAppDir.length());
                    if (!pathUnderWebapp.startsWith("/")) {
                        pathUnderWebapp = '/' + pathUnderWebapp;
                    }
                    currentUrlAsFile = new File(path + pathUnderWebapp);
                }
                throw new IllegalArgumentException("can't find path under current webapp deployment [" + webAppInfo.contextRoot + "]");
            }
            throw iae;
        }
        this.internalProcessAnnotations(currentUrlAsFile, webAppInfo, fragment, handlesTypeOnly);
    }

    private void internalProcessAnnotations(File currentUrlAsFile, WebAppInfo webAppInfo, WebXml fragment, boolean handlesTypeOnly) {
        for (ClassListInfo webAnnotated : webAppInfo.webAnnotatedClasses) {
            try {
                if (!this.isIncludedIn(webAnnotated.name, currentUrlAsFile)) continue;
                this.internalProcessAnnotationsStream(webAnnotated.list, fragment, handlesTypeOnly);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalProcessAnnotationsStream(Collection<String> urls, WebXml fragment, boolean handlesTypeOnly) {
        Iterator<String> i$ = urls.iterator();
        while (i$.hasNext()) {
            String url = i$.next();
            InputStream is = null;
            try {
                is = new URL(url).openStream();
                this.processAnnotationsStream(is, fragment, handlesTypeOnly);
            }
            catch (MalformedURLException e) {
                try {
                    throw new IllegalArgumentException(e);
                    catch (IOException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((Closeable)is);
        }
        return;
    }

    private boolean isIncludedIn(String filePath, File classAsFile) throws MalformedURLException {
        File file = URLs.toFile((URL)new URL(filePath));
        boolean webInf = false;
        for (File current = classAsFile; current != null && current.exists(); current = current.getParentFile()) {
            if (current.equals(file)) {
                File parent = current.getParentFile();
                if ("classes".equals(current.getName()) && parent != null && "WEB-INF".equals(parent.getName())) {
                    if (this.webInfClassesAnnotationsProcessed) {
                        return false;
                    }
                    this.webInfClassesAnnotationsProcessed = true;
                    return true;
                }
                return true;
            }
            if (!current.getName().equals("WEB-INF")) continue;
            webInf = true;
        }
        return !webInf;
    }

    public class OpenEJBWebXml
    extends WebXml {
        public static final String OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY = "openejb.web.xml.major";
        private String prefix;

        public OpenEJBWebXml(String prefix) {
            this.prefix = prefix;
        }

        public int getMajorVersion() {
            return SystemInstance.get().getOptions().get(this.prefix + "." + OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, SystemInstance.get().getOptions().get(OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, super.getMajorVersion()));
        }
    }
}

