/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;

public class LazyStopWebappClassLoader
extends WebappClassLoader {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)LazyStopWebappClassLoader.class.getName());
    private static final ThreadLocal<ClassLoaderConfigurer> INIT_CONFIGURER = new ThreadLocal();
    public static final String TOMEE_WEBAPP_FIRST = "tomee.webapp-first";
    private boolean restarting = false;
    private boolean forceStopPhase = Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.webappclassloader.force-stop-phase", "false"));
    private ClassLoaderConfigurer configurer = null;
    private final int hashCode;

    private void setj2seClassLoader(ClassLoader loader) {
        try {
            Field field = WebappClassLoader.class.getDeclaredField("j2seClassLoader");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (Modifier.isFinal(field.getModifiers())) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.set((Object)this, loader);
        }
        catch (Exception e) {
            LOGGER.warning("Can't set field j2seClassLoader");
        }
    }

    public LazyStopWebappClassLoader() {
        this.setj2seClassLoader(LazyStopWebappClassLoader.getSystemClassLoader());
        this.hashCode = this.construct();
    }

    public LazyStopWebappClassLoader(ClassLoader parent) {
        super(parent);
        this.setj2seClassLoader(LazyStopWebappClassLoader.getSystemClassLoader());
        this.hashCode = this.construct();
    }

    private int construct() {
        this.setDelegate(LazyStopWebappClassLoader.isDelegate());
        this.configurer = INIT_CONFIGURER.get();
        return super.hashCode();
    }

    public void stop() throws LifecycleException {
        if (this.forceStopPhase && this.restarting) {
            this.internalStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("org.apache.openejb.hibernate.OpenEJBJtaPlatform".equals(name) || "org.apache.openejb.jpa.integration.hibernate.PrefixNamingStrategy".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.PrefixSessionCustomizer".equals(name) || "org.apache.openejb.eclipselink.JTATransactionController".equals(name) || "org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
            synchronized (lazyStopWebappClassLoader) {
                Class clazz;
                ClassLoader old = this.j2seClassLoader;
                this.setj2seClassLoader(NoClassClassLoader.INSTANCE);
                boolean delegate = this.getDelegate();
                this.setDelegate(false);
                try {
                    clazz = super.loadClass(name);
                    this.setj2seClassLoader(old);
                }
                catch (Throwable throwable) {
                    this.setj2seClassLoader(old);
                    this.setDelegate(delegate);
                    throw throwable;
                }
                this.setDelegate(delegate);
                return clazz;
            }
        }
        if (URLClassLoaderFirst.shouldDelegateToTheContainer((ClassLoader)((Object)this), (String)name)) {
            try {
                return OpenEJB.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name);
            }
            catch (NoClassDefFoundError ncdfe) {
                return super.loadClass(name);
            }
        }
        if (name.startsWith("javax.faces.") || name.startsWith("org.apache.webbeans.jsf.")) {
            boolean delegate = this.getDelegate();
            LazyStopWebappClassLoader lazyStopWebappClassLoader = this;
            synchronized (lazyStopWebappClassLoader) {
                Class clazz;
                this.setDelegate(false);
                try {
                    clazz = super.loadClass(name);
                }
                catch (Throwable throwable) {
                    this.setDelegate(delegate);
                    throw throwable;
                }
                this.setDelegate(delegate);
                return clazz;
            }
        }
        return super.loadClass(name);
    }

    protected boolean validate(String name) {
        return !URLClassLoaderFirst.shouldSkip((String)name);
    }

    protected boolean filter(String name) {
        return !"org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name) && URLClassLoaderFirst.shouldSkip((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalStop() throws LifecycleException {
        if (this.isStarted()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this));
            try {
                super.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    public void restarting() {
        this.restarting = true;
    }

    public void restarted() {
        this.restarting = false;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.configurer != null) {
            URL[] enrichment;
            for (URL url : enrichment = this.configurer.additionalURLs()) {
                super.addURL(url);
            }
        }
        for (URL url : ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment((ClassLoader)((Object)this))) {
            super.addURL(url);
        }
    }

    public void addURL(URL url) {
        if (this.configurer == null || this.configurer.accept(url)) {
            super.addURL(url);
        }
    }

    protected boolean validateJarFile(File file) throws IOException {
        return super.validateJarFile(file) && TomEEClassLoaderEnricher.validateJarFile(file) && this.jarIsAccepted(file);
    }

    private boolean jarIsAccepted(File file) {
        if (this.configurer == null) {
            return true;
        }
        try {
            if (!this.configurer.accept(file.toURI().toURL())) {
                LOGGER.warning("jar '" + file.getAbsolutePath() + "' is excluded: " + file.getName() + ". It will be ignored.");
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isDelegate() {
        return !SystemInstance.get().getOptions().get(TOMEE_WEBAPP_FIRST, true);
    }

    public InputStream getResourceAsStream(String name) {
        if (!this.isStarted()) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.isStarted()) {
            return null;
        }
        if ("META-INF/services/javax.servlet.ServletContainerInitializer".equals(name)) {
            ArrayList list = new ArrayList(Collections.list(super.getResources(name)));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                URL next = (URL)it.next();
                File file = Files.toFile((URL)next);
                if (file.isFile() || !NewLoaderLogic.skip((URL)next)) continue;
                it.remove();
            }
            return Collections.enumeration(list);
        }
        return URLClassLoaderFirst.filterResources((String)name, (Enumeration)super.getResources(name));
    }

    public boolean equals(Object other) {
        return other != null && ClassLoader.class.isInstance(other) && this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "LazyStop" + super.toString();
    }

    public static void initContext(ClassLoaderConfigurer configurer) {
        INIT_CONFIGURER.set(configurer);
    }

    public static void cleanInitContext() {
        INIT_CONFIGURER.remove();
    }

    private static class NoClassClassLoader
    extends ClassLoader {
        private static final NoClassClassLoader INSTANCE = new NoClassClassLoader();

        private NoClassClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }
    }
}

