/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cluster;

import java.io.File;
import java.util.Set;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.tomee.catalina.cluster.DeployMessage;
import org.apache.tomee.catalina.cluster.UndeployMessage;

public class ClusterObserver {
    private static final boolean ClUSTER_DEPLOYMENT = "true".equals(SystemInstance.get().getProperty("tomee.cluster.deployment", "false"));
    private final Set<CatalinaCluster> clusters;

    public ClusterObserver(Set<CatalinaCluster> clusters) {
        this.clusters = clusters;
    }

    public void deploy(@Observes AssemblerAfterApplicationCreated app) {
        if (!ClUSTER_DEPLOYMENT) {
            return;
        }
        AppInfo appInfo = app.getApp();
        this.send((ClusterMessage)new DeployMessage(appInfo.path), appInfo);
    }

    public void undeploy(@Observes AssemblerBeforeApplicationDestroyed app) {
        if (!ClUSTER_DEPLOYMENT) {
            return;
        }
        AppInfo appInfo = app.getApp();
        this.send((ClusterMessage)new UndeployMessage(appInfo.path), appInfo);
    }

    private void send(ClusterMessage message, AppInfo app) {
        for (CatalinaCluster cluster : this.clusters) {
            String path = app.path;
            if (!new File(path).exists() || app.autoDeploy) continue;
            cluster.send(message);
        }
    }
}

