/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.deployment;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.WebAppDeployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomcatWebAppBuilder;

public class TomcatWebappDeployer
implements WebAppDeployer {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomcatWebappDeployer.class);

    public AppInfo deploy(String context, File file) {
        TomcatWebAppBuilder tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        Collection<String> alreadyDeployed = tomcatWebAppBuilder.availableApps();
        try {
            tomcatWebAppBuilder.deployWebApps(TomcatWebappDeployer.fakeInfo(file, context), null);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
        TomcatWebAppBuilder.ContextInfo info = this.contextInfo(file);
        if (info == null) {
            Collection<String> deployedNow = tomcatWebAppBuilder.availableApps();
            Iterator<String> it = deployedNow.iterator();
            while (it.hasNext()) {
                if (!alreadyDeployed.contains(it.next())) continue;
                it.remove();
            }
            if (deployedNow.size() == 1) {
                info = this.contextInfo(new File(deployedNow.iterator().next()));
            }
        }
        if (info == null || info.appInfo == null) {
            LOGGER.error("Can't find of appInfo for " + (file != null ? file.getAbsolutePath() : null) + ", availables: " + tomcatWebAppBuilder.availableApps());
        }
        if (info == null) {
            return null;
        }
        return info.appInfo;
    }

    public void reload(String path) {
        File file = new File(path);
        TomcatWebAppBuilder.ContextInfo info = this.contextInfo(file);
        if (info == null || info.standardContext == null) {
            LOGGER.warning("Can't find " + path);
        } else if (info.standardContext.getReloadable()) {
            info.standardContext.reload();
        }
    }

    private TomcatWebAppBuilder.ContextInfo contextInfo(File file) {
        TomcatWebAppBuilder tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        return tomcatWebAppBuilder.standaAloneWebAppInfo(file);
    }

    private static AppInfo fakeInfo(File file, String context) {
        AppInfo info = new AppInfo();
        info.path = file.getAbsolutePath();
        info.webAppAlone = true;
        WebAppInfo webAppInfo = new WebAppInfo();
        webAppInfo.path = info.path;
        webAppInfo.contextRoot = context == null ? file.getName() : context;
        webAppInfo.moduleId = webAppInfo.contextRoot;
        info.webApps.add(webAppInfo);
        return info;
    }
}

