/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarFile;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.installer.Paths;

public final class TomEEClassLoaderEnricher
implements WebAppEnricher {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomEEClassLoaderEnricher.class);
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_SKIP = "tomee.webapp.classloader.enrichment.skip";
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_CLASSES = "tomee.webapp.classloader.enrichment.classes";
    public static final String TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_PREFIXES = "tomee.webapp.classloader.enrichment.prefixes";
    private static final String[] JAR_TO_ADD_CLASS_HELPERS;
    private static final String[] DEFAULT_PREFIXES_TO_ADD;
    private static final String[] PREFIXES_TO_ADD;
    private static final String[][] FORBIDDEN_CLASSES;

    public URL[] enrichment(ClassLoader appCl) {
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoader cl = TomEEClassLoaderEnricher.class.getClassLoader();
        if (cl != appCl && appCl != null) {
            for (String name : JAR_TO_ADD_CLASS_HELPERS) {
                try {
                    String classFileName = name.replace(".", "/") + ".class";
                    URL parentUrl = cl.getResource(classFileName);
                    File file = TomEEClassLoaderEnricher.jarLocation(parentUrl, classFileName);
                    if (file == null) continue;
                    urls.add(file.toURI().toURL());
                }
                catch (Exception e) {
                }
                catch (NoClassDefFoundError error) {
                    // empty catch block
                }
            }
        }
        Paths paths = new Paths(new File(System.getProperty("openejb.home")));
        for (String prefix : PREFIXES_TO_ADD) {
            File file = paths.findTomEELibJar(prefix);
            if (file == null) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        urls.addAll(Arrays.asList(((ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class)).applicationEnrichment()));
        return urls.toArray(new URL[urls.size()]);
    }

    private static File jarLocation(URL url, String classFileName) throws MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            String spec = url.getFile();
            return new File(JarLocation.decode((String)new URL(spec.substring(0, spec.indexOf(33))).getFile()));
        }
        if ("file".equals(url.getProtocol())) {
            return JarLocation.toFile((String)classFileName, (URL)url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateJarFile(File file) throws IOException {
        block23: {
            parent = TomEEClassLoaderEnricher.class.getClassLoader();
            jarFile = null;
            jarFile = new JarFile(file);
            arr$ = TomEEClassLoaderEnricher.FORBIDDEN_CLASSES;
            len$ = arr$.length;
            i$ = 0;
lbl8:
            // 2 sources

            while (true) {
                if (i$ < len$) {
                    name = arr$[i$];
                    found = false;
                    break block23;
                }
                var3_4 = true;
                return var3_4;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            try {
                try {
                    parent.loadClass(name[0]);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
            catch (LinkageError le) {
                // empty catch block
            }
        }
        if (found && (jarEntry = jarFile.getJarEntry(entry = name[0].replace('.', '/') + ".class")) != null) {
            if (name[1] != null && jarFile.getJarEntry(name[1].replace('.', '/') + ".class") != null) {
                TomEEClassLoaderEnricher.LOGGER.warning("jar '" + file.getAbsolutePath() + "' contains offending class: " + name[0] + "but: " + name[2]);
                var10_15 = true;
                return var10_15;
            }
            TomEEClassLoaderEnricher.LOGGER.warning("jar '" + file.getAbsolutePath() + "' contains offending class: " + name[0] + ". It will be ignored.");
            var10_16 = "true".equals(SystemInstance.get().getProperty("openejb.api." + name[0] + ".validation", "true")) == false;
            return var10_16;
        }
        ++i$;
        ** continue;
    }

    static {
        DEFAULT_PREFIXES_TO_ADD = new String[]{"openwebbeans-jsf", "tomee-mojarra", "tomee-myfaces", "openejb-jpa-integration"};
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        if (!SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_SKIP, false)) {
            String additionalEnrichments = SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_CLASSES, "");
            if (additionalEnrichments != null && !additionalEnrichments.isEmpty()) {
                for (String name : additionalEnrichments.split(",")) {
                    classes.add(name.trim());
                }
            }
            String additionalPrefixes = SystemInstance.get().getOptions().get(TOMEE_WEBAPP_CLASSLOADER_ENRICHMENT_PREFIXES, "");
            prefixes.addAll(Arrays.asList(DEFAULT_PREFIXES_TO_ADD));
            if (additionalPrefixes != null && !additionalPrefixes.isEmpty()) {
                for (String name : additionalPrefixes.split(",")) {
                    prefixes.add(name.trim());
                }
            }
        }
        JAR_TO_ADD_CLASS_HELPERS = classes.toArray(new String[classes.size()]);
        PREFIXES_TO_ADD = prefixes.toArray(new String[prefixes.size()]);
        FORBIDDEN_CLASSES = new String[][]{{"javax.persistence.Entity", null, null}, {"javax.transaction.Transaction", null, null}, {"javax.jws.WebService", null, null}, {"javax.validation.Validation", null, null}, {"javax.jms.Queue", null, null}, {"javax.enterprise.context.ApplicationScoped", null, null}, {"javax.inject.Inject", null, null}, {"javax.ws.rs.Path", "javax.ws.rs.core.Configurable", "You provide JAXRS 2 API in the webapp, we tolerate it to support some advanced feature but if you expect TomEE to provide it you should remove it"}, {"javax.ejb.EJB", null, null}, {"javax.annotation.PostConstruct", "javax.annotation.Priority", "You provide javax.annotation API 1.2 so we'll tolerate new classes but it should surely be upgraded in the container"}};
    }
}

