/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Engine;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.CallerPrincipal;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatSecurityService
extends AbstractSecurityService {
    private static final boolean ONLY_DEFAULT_REALM = "true".equals(SystemInstance.get().getProperty("tomee.realm.only-default", "false"));
    protected static final ThreadLocal<LinkedList<Subject>> runAsStack = new ThreadLocal<LinkedList<Subject>>(){

        @Override
        protected LinkedList<Subject> initialValue() {
            return new LinkedList<Subject>();
        }
    };
    private Realm defaultRealm;

    public TomcatSecurityService() {
        StandardServer server = TomcatHelper.getServer();
        for (Service service : server.findServices()) {
            Engine engine;
            if (!(service.getContainer() instanceof Engine) || (engine = (Engine)service.getContainer()).getRealm() == null) continue;
            this.defaultRealm = engine.getRealm();
            break;
        }
    }

    public boolean isCallerInRole(String role) {
        Principal principal = this.getCallerPrincipal();
        if (TomcatUser.class.isInstance(principal)) {
            TomcatUser tomcatUser = (TomcatUser)principal;
            GenericPrincipal genericPrincipal = (GenericPrincipal)tomcatUser.getTomcatPrincipal();
            String[] roles = genericPrincipal.getRoles();
            if (roles != null) {
                for (String userRole : roles) {
                    if (!userRole.equals(role)) continue;
                    return true;
                }
            }
            return false;
        }
        return super.isCallerInRole(role);
    }

    public UUID login(String realmName, String username, String password) throws LoginException {
        Realm realm = this.findRealm(realmName);
        if (realm == null) {
            throw new LoginException("No Tomcat realm available");
        }
        Principal principal = realm.authenticate(username, password);
        if (principal == null) {
            throw new CredentialNotFoundException(username);
        }
        Subject subject = this.createSubject(realm, principal);
        return this.registerSubject(subject);
    }

    private Realm findRealm(String realmName) {
        Realm r;
        if (ONLY_DEFAULT_REALM || realmName == null || realmName.isEmpty()) {
            return this.defaultRealm;
        }
        TomcatWebAppBuilder webAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(TomcatWebAppBuilder.class);
        if (webAppBuilder != null && (r = webAppBuilder.getRealms().get('/' + realmName)) != null) {
            return r;
        }
        return this.defaultRealm;
    }

    private Subject createSubject(Realm realm, Principal principal) {
        HashSet<TomcatUser> principals = new HashSet<TomcatUser>();
        principals.add(new TomcatUser(realm, principal));
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    public Set<String> getLogicalRoles(Principal[] principals, Set<String> logicalRoles) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>(logicalRoles.size());
        block0: for (String logicalRole : logicalRoles) {
            for (Principal principal : principals) {
                String name;
                if (principal instanceof TomcatUser) {
                    TomcatUser user = (TomcatUser)principal;
                    if (!TomcatHelper.hasRole((Realm)user.getRealm(), (Principal)user.getTomcatPrincipal(), (String)logicalRole)) continue;
                    roles.add(logicalRole);
                    continue block0;
                }
                if (principal == null || !logicalRole.equals(name = principal.getName())) continue;
                roles.add(logicalRole);
            }
        }
        return roles;
    }

    public Principal getCallerPrincipal() {
        AbstractSecurityService.Identity currentIdentity = (AbstractSecurityService.Identity)clientIdentity.get();
        if (currentIdentity != null) {
            Set<Principal> principals = currentIdentity.getSubject().getPrincipals();
            for (Principal principal : principals) {
                if (!principal.getClass().isAnnotationPresent(CallerPrincipal.class)) continue;
                return principal;
            }
            if (!principals.isEmpty()) {
                return principals.iterator().next();
            }
        }
        return super.getCallerPrincipal();
    }

    public Object enterWebApp(Realm realm, Principal principal, String runAs) {
        AbstractSecurityService.Identity newIdentity = null;
        if (principal != null) {
            Subject newSubject = this.createSubject(realm, principal);
            newIdentity = new AbstractSecurityService.Identity(newSubject, null);
        }
        AbstractSecurityService.Identity oldIdentity = (AbstractSecurityService.Identity)clientIdentity.get();
        WebAppState webAppState = new WebAppState(oldIdentity, runAs != null);
        clientIdentity.set(newIdentity);
        if (runAs != null) {
            Subject runAsSubject = this.createRunAsSubject(runAs);
            runAsStack.get().addFirst(runAsSubject);
        }
        return webAppState;
    }

    public void exitWebApp(Object state) {
        if (state instanceof WebAppState) {
            WebAppState webAppState = (WebAppState)state;
            if (webAppState.oldIdentity == null) {
                clientIdentity.remove();
            } else {
                clientIdentity.set(webAppState.oldIdentity);
            }
            if (webAppState.hadRunAs) {
                runAsStack.get().removeFirst();
            }
        }
    }

    protected Subject getRunAsSubject(BeanContext callingBeanContext) {
        Subject runAsSubject = super.getRunAsSubject(callingBeanContext);
        if (runAsSubject != null) {
            return runAsSubject;
        }
        LinkedList<Subject> stack = runAsStack.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.getFirst();
    }

    protected Subject createRunAsSubject(String role) {
        if (role == null) {
            return null;
        }
        HashSet<RunAsRole> principals = new HashSet<RunAsRole>();
        principals.add(new RunAsRole(role));
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    private static class WebAppState
    implements Serializable {
        private final AbstractSecurityService.Identity oldIdentity;
        private final boolean hadRunAs;

        public WebAppState(AbstractSecurityService.Identity oldIdentity, boolean hadRunAs) {
            this.oldIdentity = oldIdentity;
            this.hadRunAs = hadRunAs;
        }
    }

    protected static class RunAsRole
    implements Principal {
        private final String name;

        public RunAsRole(String name) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return "[RunAsRole: " + this.name + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunAsRole runAsRole = (RunAsRole)o;
            return this.name.equals(runAsRole.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    @CallerPrincipal
    public static class TomcatUser
    implements Principal {
        private final Realm realm;
        private final Principal tomcatPrincipal;

        public TomcatUser(Realm realm, Principal tomcatPrincipal) {
            if (realm == null) {
                throw new NullPointerException("realm is null");
            }
            if (tomcatPrincipal == null) {
                throw new NullPointerException("tomcatPrincipal is null");
            }
            this.realm = realm;
            this.tomcatPrincipal = tomcatPrincipal;
        }

        public Realm getRealm() {
            return this.realm;
        }

        public Principal getTomcatPrincipal() {
            return this.tomcatPrincipal;
        }

        @Override
        public String getName() {
            return this.tomcatPrincipal.getName();
        }

        @Override
        public String toString() {
            return "[TomcatUser: " + this.tomcatPrincipal + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TomcatUser that = (TomcatUser)o;
            return this.realm.equals(that.realm) && ((Object)this.tomcatPrincipal).equals(that.tomcatPrincipal);
        }

        @Override
        public int hashCode() {
            int result = this.realm.hashCode();
            result = 31 * result + ((Object)this.tomcatPrincipal).hashCode();
            return result;
        }
    }
}

