/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextConfig;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.ReflectionUtil;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.xml.sax.InputSource;

public class OpenEJBContextConfig
extends ContextConfig {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("catalina").createChild("context"), OpenEJBContextConfig.class);
    private TomcatWebAppBuilder.StandardContextInfo info;

    public OpenEJBContextConfig(TomcatWebAppBuilder.StandardContextInfo standardContextInfo) {
        this.info = standardContextInfo;
    }

    protected WebXml createWebXml() {
        StandardContext standardContext;
        String prefix = "";
        if (this.context instanceof StandardContext && (prefix = (standardContext = (StandardContext)this.context).getEncodedPath()).startsWith("/")) {
            prefix = prefix.substring(1);
        }
        return new OpenEJBWebXml(prefix);
    }

    protected void parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        super.parseWebXml(source, dest, fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void DISABLE_processAnnotationsUrl(URL url, WebXml fragment) {
        if (SystemInstance.get().getOptions().get("tomee.tomcat.scan", false)) {
            super.processAnnotationsUrl(url, fragment);
            return;
        }
        try {
            WebAppInfo webAppInfo = this.info.get();
            if (webAppInfo == null) {
                logger.warning("WebAppInfo not found. " + this.info);
                super.processAnnotationsUrl(url, fragment);
                return;
            }
            logger.debug("Optimized Scan of URL " + url);
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            for (String webAnnotatedClassName : webAppInfo.webAnnotatedClasses) {
                String classFile = webAnnotatedClassName.replace('.', '/') + ".class";
                URL classUrl = loader.getResource(classFile);
                if (classUrl == null) {
                    logger.debug("Not present " + webAnnotatedClassName);
                    continue;
                }
                logger.debug("Found " + webAnnotatedClassName);
                InputStream inputStream = classUrl.openStream();
                try {
                    this.processAnnotationsStream(inputStream, fragment);
                    logger.debug("Succeeded " + webAnnotatedClassName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("OpenEJBContextConfig.processAnnotationsUrl: failed.", (Throwable)e);
        }
    }

    public class OpenEJBWebXml
    extends WebXml {
        public static final String OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY = "openejb.web.xml.major";
        private String prefix;

        public OpenEJBWebXml(String prefix) {
            this.prefix = prefix;
            try {
                ReflectionUtil.set((Object)((Object)this), (String)"jspPropertyGroups", new LinkedHashSet());
            }
            catch (OpenEJBException openEJBException) {
                // empty catch block
            }
        }

        public int getMajorVersion() {
            return SystemInstance.get().getOptions().get(this.prefix + "." + OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, SystemInstance.get().getOptions().get(OPENEJB_WEB_XML_MAJOR_VERSION_PROPERTY, super.getMajorVersion()));
        }
    }
}

