/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.directory.DirContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.util.ExceptionUtils;

public class TomEEWebappLoader
extends WebappLoader {
    private ClassLoader appClassLoader;
    private ClassLoader tomEEClassLoader;
    private String appPath;

    public TomEEWebappLoader(String appId, ClassLoader classLoader) {
        this.appPath = appId;
        this.appClassLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.tomEEClassLoader;
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        ClassLoader webappCl = super.getClassLoader();
        this.tomEEClassLoader = new TomEEClassLoader(this.appPath, this.appClassLoader, webappCl);
        try {
            DirContextURLStreamHandler.bind((ClassLoader)this.tomEEClassLoader, (DirContext)this.getContainer().getResources());
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            throw new LifecycleException("start: ", t);
        }
    }

    public static class TomEEClassLoader
    extends ClassLoader {
        private ClassLoader app;
        private ClassLoader webapp;
        private String appPath;

        public TomEEClassLoader(String appId, ClassLoader appCl, ClassLoader webappCl) {
            super(webappCl);
            this.appPath = appId;
            this.app = appCl;
            this.webapp = webappCl;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            HashMap<String, URL> urls = new HashMap<String, URL>();
            if (this.webapp instanceof WebappClassLoader && ((WebappClassLoader)this.webapp).isStarted() || this.webapp.getParent() == null) {
                this.add(urls, this.app.getResources(name));
                this.add(urls, this.webapp.getResources(name));
                return new ArrayEnumeration(this.clear(urls.values()));
            }
            return this.app.getResources(name);
        }

        private List<URL> clear(Iterable<URL> urls) {
            ArrayList<URL> clean = new ArrayList<URL>();
            for (URL url : urls) {
                String urlStr = url.toExternalForm();
                URL jarUrl = null;
                if (urlStr.contains("!")) {
                    try {
                        jarUrl = new URL(urlStr.substring(0, urlStr.lastIndexOf(33)) + "!/");
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (jarUrl != null) {
                    URL cachedFile = ClassLoaderUtil.getUrlKeyCached((String)this.appPath, (File)TomEEClassLoader.file(jarUrl));
                    if (cachedFile != null) {
                        URL resource = null;
                        try {
                            resource = new URL("jar:file:" + cachedFile.getFile() + urlStr.substring(urlStr.lastIndexOf(33)));
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                        if (resource == null || clean.contains(resource)) continue;
                        clean.add(resource);
                        continue;
                    }
                    clean.add(url);
                    continue;
                }
                if (clean.contains(url)) continue;
                clean.add(url);
            }
            return clean;
        }

        private void add(Map<String, URL> urls, Enumeration<URL> enumUrls) {
            try {
                while (enumUrls.hasMoreElements()) {
                    URL url = enumUrls.nextElement();
                    urls.put(url.toExternalForm(), url);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        private static File file(URL jarUrl) {
            return URLs.toFile((URL)jarUrl);
        }
    }
}

