/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.naming.NamingException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.WebAppDeployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.embedded.Configuration;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.log.NullLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class Container
implements Closeable {
    private final Map<String, String> moduleIds = new HashMap<String, String>();
    private final Map<String, AppContext> appContexts = new HashMap<String, AppContext>();
    private final Map<String, AppInfo> infos = new HashMap<String, AppInfo>();
    protected Configuration configuration;
    private File base;
    private ConfigurationFactory configurationFactory;
    private Assembler assembler;
    private Tomcat tomcat;

    public Container(Configuration configuration) throws Exception {
        this.setup(configuration);
        this.start();
    }

    public Container() {
        this.configuration = new Configuration();
        this.configuration.setHttpPort(23880);
        this.configuration.setStopPort(23881);
    }

    private static boolean sameApplication(File file, WebAppInfo webApp) {
        String filename = file.getName();
        if (filename.endsWith(".war")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        return filename.equals(webApp.moduleId);
    }

    private static String lastPart(String name, String defaultValue) {
        int idx = name.lastIndexOf("/");
        int space = name.lastIndexOf(" ");
        if (idx >= 0 && space < idx) {
            return name.substring(idx);
        }
        if (idx < 0 && space < 0) {
            return name;
        }
        return defaultValue;
    }

    public void setup(Configuration configuration) {
        this.configuration = configuration;
        this.tomcat = configuration.isQuickSession() ? new TomcatWithFastSessionIDs() : new Tomcat();
        this.base = new File(this.getBaseDir());
        if (this.base.exists()) {
            Files.delete((File)this.base);
        }
        Files.mkdirs((File)this.base);
        Files.deleteOnExit((File)this.base);
        this.createDirectory(this.base, "conf");
        this.createDirectory(this.base, "lib");
        this.createDirectory(this.base, "logs");
        this.createDirectory(this.base, "temp");
        this.createDirectory(this.base, "work");
        this.createDirectory(this.base, "webapps");
    }

    public File getBase() {
        return this.base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Properties props;
        if (this.base == null || !this.base.exists()) {
            this.setup(this.configuration);
        }
        if ((props = this.configuration.getProperties()) != null) {
            Logger.configure((Properties)this.configuration.getProperties());
        } else {
            Logger.configure();
        }
        File conf = new File(this.base, "conf");
        File webapps = new File(this.base, "webapps");
        this.copyFileTo(conf, "catalina.policy");
        this.copyTemplateTo(conf, "catalina.properties");
        this.copyFileTo(conf, "context.xml");
        this.copyFileTo(conf, "openejb.xml");
        this.copyFileTo(conf, "tomcat-users.xml");
        this.copyFileTo(conf, "web.xml");
        if (this.configuration.hasServerXml()) {
            FileOutputStream fos = new FileOutputStream(new File(conf, "server.xml"));
            try {
                IO.copy((File)this.configuration.getServerXmlFile(), (OutputStream)fos);
            }
            finally {
                IO.close((Closeable)fos);
            }
        } else {
            this.copyFileTo(conf, "server.xml");
        }
        if (props != null && !props.isEmpty()) {
            FileWriter systemProperties = new FileWriter(new File(conf, "system.properties"));
            try {
                props.store(systemProperties, "");
            }
            finally {
                IO.close((Closeable)systemProperties);
            }
        }
        System.setProperty("catalina.base", this.base.getAbsolutePath());
        CatalinaProperties.getProperty((String)"foo");
        this.tomcat.setBaseDir(this.base.getAbsolutePath());
        this.tomcat.getHost().setAppBase(webapps.getAbsolutePath());
        this.tomcat.setHostname(this.configuration.getHost());
        this.tomcat.getEngine().setDefaultHost(this.configuration.getHost());
        if (!this.configuration.isSkipHttp()) {
            Connector connector = new Connector(Http11Protocol.class.getName());
            connector.setPort(this.configuration.getHttpPort());
            connector.setAttribute("connectionTimeout", (Object)"5000");
            this.tomcat.getService().addConnector(connector);
            this.tomcat.setConnector(connector);
        }
        if (this.configuration.isSsl()) {
            Connector httpsConnector = new Connector(Http11Protocol.class.getName());
            httpsConnector.setPort(this.configuration.getHttpsPort());
            httpsConnector.setSecure(true);
            httpsConnector.setProperty("SSLEnabled", "true");
            httpsConnector.setProperty("sslProtocol", this.configuration.getSslProtocol());
            if (this.configuration.getKeystoreFile() != null) {
                httpsConnector.setAttribute("keystoreFile", (Object)this.configuration.getKeystoreFile());
            }
            if (this.configuration.getKeystorePass() != null) {
                httpsConnector.setAttribute("keystorePass", (Object)this.configuration.getKeystorePass());
            }
            httpsConnector.setAttribute("keystoreType", (Object)this.configuration.getKeystoreType());
            httpsConnector.setAttribute("clientAuth", (Object)this.configuration.getClientAuth());
            httpsConnector.setAttribute("keyAlias", (Object)this.configuration.getKeyAlias());
            this.tomcat.getService().addConnector(httpsConnector);
            if (this.configuration.isSkipHttp()) {
                this.tomcat.setConnector(httpsConnector);
            }
        }
        Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, Container.class).info("Starting TomEE from: " + this.base.getAbsolutePath());
        if (this.configuration.getUsers() != null) {
            for (Map.Entry<String, String> user : this.configuration.getUsers().entrySet()) {
                this.tomcat.addUser(user.getKey(), user.getValue());
            }
        }
        if (this.configuration.getRoles() != null) {
            for (Map.Entry<String, String> user : this.configuration.getRoles().entrySet()) {
                for (String role : user.getValue().split(" *, *")) {
                    this.tomcat.addRole(user.getKey(), role);
                }
            }
        }
        String catalinaBase = this.base.getAbsolutePath();
        System.setProperty("openejb.deployments.classpath", "false");
        System.setProperty("catalina.home", catalinaBase);
        System.setProperty("catalina.base", catalinaBase);
        System.setProperty("openejb.home", catalinaBase);
        System.setProperty("openejb.base", catalinaBase);
        System.setProperty("openejb.servicemanager.enabled", "false");
        this.tomcat.start();
        Properties properties = new Properties();
        properties.setProperty("openejb.deployments.classpath", "false");
        properties.setProperty("openejb.loader", "tomcat-system");
        properties.setProperty("openejb.home", catalinaBase);
        properties.setProperty("openejb.base", catalinaBase);
        properties.setProperty("openejb.servicemanager.enabled", "false");
        if (this.configuration.getProperties() != null) {
            properties.putAll((Map<?, ?>)this.configuration.getProperties());
        }
        if (properties.getProperty("openejb.system.apps") == null) {
            properties.setProperty("openejb.system.apps", "false");
        }
        try {
            String serverBuilt;
            String serverInfo;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
            String serverNumber = tomcatServerInfo.getProperty("server.number");
            if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                int slash = serverInfo.indexOf(47);
                serverNumber = serverInfo.substring(slash + 1);
            }
            if (serverNumber != null) {
                System.setProperty("tomcat.version", serverNumber);
            }
            if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                System.setProperty("tomcat.built", serverBuilt);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        TomcatLoader loader = new TomcatLoader();
        loader.initDefaults(properties);
        Properties initProps = new Properties();
        initProps.putAll((Map<?, ?>)System.getProperties());
        initProps.putAll((Map<?, ?>)properties);
        SystemInstance.init((Properties)initProps);
        SystemInstance.get().setComponent(StandardServer.class, (Object)((StandardServer)this.tomcat.getServer()));
        SystemInstance.get().setComponent(Server.class, (Object)this.tomcat.getServer());
        loader.initialize(properties);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = new ConfigurationFactory();
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    private String getBaseDir() {
        try {
            File file;
            String dir = this.configuration.getDir();
            if (dir != null) {
                File dirFile = new File(dir);
                if (dirFile.exists()) {
                    return dir;
                }
                return Files.mkdir((File)dirFile).getAbsolutePath();
            }
            try {
                File target = new File("target");
                file = File.createTempFile("apache-tomee", "-home", target.exists() ? target : null);
            }
            catch (Throwable e) {
                File tmp = new File("tmp");
                if (!tmp.exists() && !tmp.mkdirs()) {
                    throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                }
                file = File.createTempFile("apache-tomee", "-home", tmp);
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new TomEERuntimeException("Failed to get or create base dir: " + this.configuration.getDir(), (Throwable)e);
        }
    }

    public void stop() throws Exception {
        Connector connector = this.tomcat.getConnector();
        if (null != connector) {
            connector.stop();
        }
        try {
            this.tomcat.stop();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        try {
            this.tomcat.destroy();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        try {
            this.deleteTree(this.base);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OpenEJB.destroy();
    }

    public AppContext deploy(String name, File file) throws OpenEJBException, IOException, NamingException {
        return this.deploy(name, file, false);
    }

    public AppContext deploy(String name, File file, boolean overrideName) throws OpenEJBException, IOException, NamingException {
        Object context;
        AppInfo appInfo;
        if (WebAppDeployer.Helper.isWebApp((File)file)) {
            String contextRoot = file.getName();
            if (overrideName) {
                contextRoot = name;
            }
            context = (appInfo = ((WebAppDeployer)SystemInstance.get().getComponent(WebAppDeployer.class)).deploy(null, contextRoot, file)) != null ? ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContext((Object)appInfo.appId) : null;
        } else {
            appInfo = this.configurationFactory.configureApplication(file);
            if (overrideName) {
                appInfo.appId = name;
                for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                    if (file.getName().equals(ejbJar.moduleName)) {
                        ejbJar.moduleName = name;
                        ejbJar.moduleId = name;
                    }
                    for (EnterpriseBeanInfo ejb : ejbJar.enterpriseBeans) {
                        if (!BeanContext.Comp.openejbCompName((String)file.getName()).equals(ejb.ejbName)) continue;
                        ejb.ejbName = BeanContext.Comp.openejbCompName((String)name);
                    }
                }
                for (WebAppInfo webApp : appInfo.webApps) {
                    if (!Container.sameApplication(file, webApp)) continue;
                    webApp.moduleId = name;
                    webApp.contextRoot = Container.lastPart(name, webApp.contextRoot);
                    if (!"ROOT".equals(webApp.contextRoot)) continue;
                    webApp.contextRoot = "";
                }
            }
            context = this.assembler.createApplication(appInfo);
        }
        this.moduleIds.put(name, null != appInfo ? appInfo.path : null);
        this.infos.put(name, appInfo);
        this.appContexts.put(name, (AppContext)context);
        return context;
    }

    public AppInfo getInfo(String name) {
        return this.infos.get(name);
    }

    public void undeploy(String name) throws UndeployException, NoSuchApplicationException {
        String moduleId = this.moduleIds.remove(name);
        this.infos.remove(name);
        this.appContexts.remove(name);
        if (moduleId != null) {
            this.assembler.destroyApplication(moduleId);
        }
    }

    public javax.naming.Context getJndiContext() {
        return this.assembler.getContainerSystem().getJNDIContext();
    }

    public AppContext getAppContexts(String moduleId) {
        return this.appContexts.get(moduleId);
    }

    private void deleteTree(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (!file.delete()) {
                file.deleteOnExit();
            }
            return;
        }
        if (file.isDirectory()) {
            if ("".equals(file.getName())) {
                return;
            }
            if ("src/main".equals(file.getName())) {
                return;
            }
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.deleteTree(child);
                }
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private void copyTemplateTo(File targetDir, String filename) throws Exception {
        Velocity.setProperty((String)"runtime.log.logsystem", (Object)new NullLogChute());
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
        Template template = Velocity.getTemplate((String)("/org/apache/tomee/configs/" + filename));
        VelocityContext context = new VelocityContext();
        context.put("tomcatHttpPort", (Object)Integer.toString(this.configuration.getHttpPort()));
        context.put("tomcatShutdownPort", (Object)Integer.toString(this.configuration.getStopPort()));
        FileWriter writer = new FileWriter(new File(targetDir, filename));
        template.merge((org.apache.velocity.context.Context)context, (Writer)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(File targetDir, String filename) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/org/apache/tomee/configs/" + filename);
        if (is != null) {
            try {
                IO.copy((InputStream)is, (File)new File(targetDir, filename));
            }
            finally {
                IO.close((Closeable)is);
            }
        }
    }

    private File createDirectory(File parent, String directory) {
        File dir = new File(parent, directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to make dir " + dir.getAbsolutePath());
        }
        return dir;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public void await() {
        this.tomcat.getServer().await();
    }

    @Override
    public void close() throws IOException {
        final CountDownLatch end = new CountDownLatch(1);
        final Container container = this;
        new Thread(){
            {
                this.setName("tomee-embedded-await-" + this.hashCode());
            }

            @Override
            public void run() {
                try {
                    container.await();
                    end.countDown();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }.start();
        try {
            container.stop();
        }
        catch (Exception e) {
            throw new IOException("Failed to stop container", e);
        }
        try {
            end.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public Context addContext(String context, String path) {
        File root = new File(path);
        if (!root.exists()) {
            Files.mkdirs((File)root);
        }
        return this.getTomcat().addContext(context, root.getAbsolutePath());
    }

    static {
        Assembler.installNaming((String)"org.apache.naming", (boolean)true);
    }

    private static class TomcatWithFastSessionIDs
    extends Tomcat {
        private TomcatWithFastSessionIDs() {
        }

        public void start() throws LifecycleException {
            Server server = this.getServer();
            for (Service service : server.findServices()) {
                org.apache.catalina.Container e = service.getContainer();
                for (org.apache.catalina.Container h : e.findChildren()) {
                    for (org.apache.catalina.Container c : h.findChildren()) {
                        StandardManager m = (StandardManager)c.getManager();
                        if (m != null) continue;
                        m = new StandardManager();
                        m.setSecureRandomClass("org.apache.catalina.startup.FastNonSecureRandom");
                        c.setManager((Manager)m);
                    }
                }
            }
            super.start();
        }
    }
}

