/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsServlet;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatRsRegistry
implements RsRegistry {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatRsRegistry.class);
    private Engine engine;
    private List<Connector> connectors;
    private final Map<String, HttpListener> listeners = new TreeMap<String, HttpListener>();

    public TomcatRsRegistry() {
        StandardServer standardServer = TomcatHelper.getServer();
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            this.engine = (Engine)service.getContainer();
            break;
        }
    }

    public RsRegistry.AddressInfo createRsHttpListener(String webContext, HttpListener listener, ClassLoader classLoader, String completePath, String virtualHost) {
        Container host;
        String path = webContext;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (virtualHost == null) {
            virtualHost = this.engine.getDefaultHost();
        }
        if ((host = this.engine.findChild(virtualHost)) == null) {
            throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
        }
        Context context = (Context)host.findChild(webContext);
        if (context == null && "/".equals(webContext)) {
            context = (Context)host.findChild("");
        }
        if (context == null) {
            throw new IllegalStateException("Invalid context '" + webContext + "'.  Cannot find context in host " + host.getName());
        }
        Wrapper wrapper = context.createWrapper();
        String name = "rest_" + listener.hashCode();
        wrapper.setName(name);
        wrapper.setServletClass(RsServlet.class.getName());
        context.addChild((Container)wrapper);
        wrapper.addMapping(TomcatRsRegistry.removeWebContext(webContext, completePath));
        context.addServletMapping(completePath, name);
        String listenerId = wrapper.getName() + RsServlet.class.getName() + listener.hashCode();
        wrapper.addInitParameter(HttpListener.class.getName(), listenerId);
        context.getServletContext().setAttribute(listenerId, (Object)listener);
        path = TomcatRsRegistry.address(this.connectors, host.getName(), webContext);
        String key = TomcatRsRegistry.address(this.connectors, host.getName(), completePath);
        this.listeners.put(key, listener);
        return new RsRegistry.AddressInfo(path, key);
    }

    private static String removeWebContext(String webContext, String completePath) {
        if (webContext == null) {
            return completePath;
        }
        return completePath.substring(webContext.length());
    }

    private static String address(Collection<Connector> connectors, String host, String path) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : connectors) {
            URI address;
            try {
                address = new URI(connector.getScheme(), null, host, connector.getPort(), path, null, null);
            }
            catch (Exception e) {
                LOGGER.error("can't add container for path " + path, (Throwable)e);
                continue;
            }
            addresses.add(address.toString());
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    public HttpListener removeListener(String completePath) {
        String path = completePath;
        if (path == null) {
            return this.listeners.get(path);
        }
        if (!(path.startsWith("/") || path.startsWith("http://") || path.startsWith("https://"))) {
            path = "/" + path;
        }
        if (this.listeners.containsKey(path)) {
            return this.listeners.remove(path);
        }
        return null;
    }
}

