/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.cipher.PasswordCipher;
import org.apache.openejb.resource.jdbc.plugin.DataSourcePlugin;
import org.apache.openejb.resource.jdbc.pool.PoolDataSourceCreator;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Strings;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.PooledConnection;

public class TomEEDataSourceCreator
extends PoolDataSourceCreator {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomEEDataSourceCreator.class);

    public javax.sql.DataSource pool(String name, javax.sql.DataSource ds, Properties properties) {
        ConnectionPool pool;
        Properties converted = new Properties();
        SuperProperties prop = new SuperProperties().caseInsensitive(true);
        prop.putAll((Map)properties);
        this.updateProperties(prop, converted, null);
        PoolConfiguration config = (PoolConfiguration)this.build(PoolProperties.class, converted);
        config.setDataSource((Object)ds);
        try {
            pool = new ConnectionPool(config);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return (javax.sql.DataSource)this.build(TomEEDataSource.class, (Object)new TomEEDataSource(config, pool, name), converted);
    }

    public javax.sql.DataSource pool(String name, String driver, Properties properties) {
        Properties converted = new Properties();
        converted.setProperty("name", name);
        SuperProperties prop = new SuperProperties().caseInsensitive(true);
        prop.putAll((Map)properties);
        this.updateProperties(prop, converted, driver);
        PoolConfiguration config = (PoolConfiguration)this.build(PoolProperties.class, converted);
        return (javax.sql.DataSource)this.build(TomEEDataSource.class, (Object)new TomEEDataSource(config, name), converted);
    }

    private void updateProperties(SuperProperties properties, Properties converted, String driver) {
        String currentUrl;
        String passwordCipher;
        String user;
        String url;
        String jdbcDriver;
        if (driver != null && !properties.containsKey((Object)"driverClassName")) {
            converted.setProperty("driverClassName", driver);
        }
        if ((jdbcDriver = (String)properties.remove((Object)"JdbcDriver")) != null && !properties.containsKey((Object)"driverClassName")) {
            converted.setProperty("driverClassName", jdbcDriver);
        }
        if ((url = (String)properties.remove((Object)"JdbcUrl")) != null && !properties.containsKey((Object)"url")) {
            converted.setProperty("url", url);
        }
        if ((user = (String)properties.remove((Object)"user")) != null && !properties.containsKey((Object)"username")) {
            converted.setProperty("username", user);
        }
        String maxWait = this.toMillis((String)properties.remove((Object)"maxWaitTime"));
        if (properties.containsKey((Object)"maxWaitTime") && !properties.containsKey((Object)"maxWait")) {
            converted.setProperty("maxWait", maxWait);
        }
        String tb = this.toMillis((String)properties.remove((Object)"timeBetweenEvictionRuns"));
        if (properties.containsKey((Object)"timeBetweenEvictionRuns") && !properties.containsKey((Object)"timeBetweenEvictionRunsMillis")) {
            converted.setProperty("timeBetweenEvictionRunsMillis", tb);
        }
        String minEvict = this.toMillis((String)properties.remove((Object)"minEvictableIdleTime"));
        if (properties.containsKey((Object)"minEvictableIdleTime") && !properties.containsKey((Object)"minEvictableIdleTimeMillis")) {
            converted.setProperty("minEvictableIdleTimeMillis", minEvict);
        }
        if ((passwordCipher = properties.getProperty("PasswordCipher")) != null && "PlainText".equals(passwordCipher)) {
            properties.remove((Object)"PasswordCipher");
        } else {
            String password = properties.getProperty("Password");
            if (passwordCipher != null) {
                try {
                    PasswordCipher cipher = BasicDataSourceUtil.getPasswordCipher((String)passwordCipher);
                    String plainPwd = cipher.decrypt(password.toCharArray());
                    converted.setProperty("password", plainPwd);
                    properties.remove((Object)"PasswordCipher");
                    properties.remove((Object)"Password");
                }
                catch (SQLException e) {
                    LOGGER.error("Can't decrypt password", (Throwable)e);
                }
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString().trim();
            if (value.isEmpty() || converted.containsKey(key)) continue;
            if ("MaxOpenPreparedStatements".equalsIgnoreCase(key) || "PoolPreparedStatements".equalsIgnoreCase(key)) {
                String interceptors = properties.getProperty("jdbcInterceptors");
                if (interceptors != null && interceptors.contains("StatementCache")) continue;
                converted.setProperty("jdbcInterceptors", "StatementCache(max=" + properties.getProperty("MaxOpenPreparedStatements", "128") + ")");
                LOGGER.debug("Tomcat-jdbc StatementCache added to handle prepared statement cache/pool");
                continue;
            }
            converted.put(Strings.lcfirst((String)key), value);
        }
        if (!converted.containsKey("password")) {
            converted.setProperty("password", "");
        }
        if ((currentUrl = converted.getProperty("url")) != null) {
            try {
                String newUrl;
                DataSourcePlugin helper = BasicDataSourceUtil.getDataSourcePlugin((String)currentUrl);
                if (helper != null && !currentUrl.equals(newUrl = helper.updatedUrl(currentUrl))) {
                    properties.setProperty("url", newUrl);
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
    }

    private String toMillis(String d) {
        if (d == null) {
            return null;
        }
        return Long.toString(new Duration(d).getTime(TimeUnit.MILLISECONDS));
    }

    public void doDestroy(javax.sql.DataSource object) throws Throwable {
        DataSource ds = (DataSource)object;
        if (ds instanceof TomEEDataSource) {
            ((TomEEDataSource)ds).internalJMXUnregister();
        }
        ds.close(true);
    }

    private static class ContantHashCodeHandler
    implements InvocationHandler {
        private final Object delegate;
        private final int hashCode;

        public ContantHashCodeHandler(Object object, int hashCode) {
            this.delegate = object;
            this.hashCode = hashCode;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("hashCode".equals(method.getName())) {
                return this.hashCode;
            }
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    private static class TomEEConnectionPool
    extends ConnectionPool {
        public TomEEConnectionPool(PoolConfiguration poolProperties) throws SQLException {
            super(poolProperties);
        }

        protected PooledConnection create(boolean incrementCounter) {
            PooledConnection con = super.create(incrementCounter);
            if (this.getPoolProperties().getDataSource() == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = TomEEConnectionPool.class.getClassLoader();
                }
                try {
                    Reflections.set((Object)con, (String)"driver", Class.forName(this.getPoolProperties().getDriverClassName(), true, cl).newInstance());
                }
                catch (Exception cn) {
                    // empty catch block
                }
            }
            return con;
        }
    }

    private static class ReadOnlyConnectionpool
    implements InvocationHandler {
        private final PoolConfiguration delegate;

        public ReadOnlyConnectionpool(PoolConfiguration pool) {
            this.delegate = pool;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!method.getName().startsWith("set") || args == null || args.length != 1 || !Void.TYPE.equals(method.getReturnType())) {
                return method.invoke((Object)this.delegate, args);
            }
            return null;
        }
    }

    public static class TomEEDataSource
    extends DataSource {
        private static final Log LOGGER = LogFactory.getLog(TomEEDataSource.class);
        private static final Class<?>[] CONNECTION_POOL_CLASS = new Class[]{PoolConfiguration.class};
        private ObjectName internalOn = null;

        public TomEEDataSource(PoolConfiguration properties, ConnectionPool pool, String name) {
            super(TomEEDataSource.readOnly(properties));
            this.pool = pool;
            this.initJmx(name);
        }

        public TomEEDataSource(PoolConfiguration poolConfiguration, String name) {
            super(TomEEDataSource.readOnly(poolConfiguration));
            try {
                this.createPool();
                this.initJmx(name);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Can't create DataSource", e);
            }
        }

        public ConnectionPool createPool() throws SQLException {
            if (this.pool != null) {
                return this.pool;
            }
            this.pool = new TomEEConnectionPool(this.poolProperties);
            return this.pool;
        }

        private static PoolConfiguration readOnly(PoolConfiguration pool) {
            return (PoolConfiguration)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_POOL_CLASS, (InvocationHandler)new ReadOnlyConnectionpool(pool));
        }

        private void initJmx(String name) {
            try {
                this.internalOn = ObjectNameBuilder.uniqueName((String)"datasources", (String)name, (Object)((Object)this));
                try {
                    if (this.pool.getJmxPool() != null) {
                        LocalMBeanServer.get().registerMBean(this.pool.getJmxPool(), this.internalOn);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to register JDBC pool with JMX", (Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void internalJMXUnregister() {
            if (this.internalOn != null) {
                try {
                    LocalMBeanServer.get().unregisterMBean(this.internalOn);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unable to unregister JDBC pool with JMX", (Throwable)e);
                }
            }
        }

        public Connection getConnection() throws SQLException {
            Connection connection = super.getConnection();
            return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ContantHashCodeHandler(connection, connection.hashCode()));
        }

        public Connection getConnection(String u, String p) throws SQLException {
            Connection connection = super.getConnection(u, p);
            return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ContantHashCodeHandler(connection, connection.hashCode()));
        }
    }
}

