/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class TomEELogConfigurer
extends LogFactory {
    public static void configureLogs() {
        if (Boolean.getBoolean("tomee.skip-tomcat-log")) {
            return;
        }
        Thread thread = Thread.currentThread();
        try {
            ClassLoader tccl = thread.getContextClassLoader();
            Class<?> logger = tccl.loadClass("org.apache.openejb.util.Logger");
            Method m = logger.getDeclaredMethod("delegateClass", new Class[0]);
            String clazz = (String)m.invoke(null, new Object[0]);
            LogFactory factory = "org.apache.openejb.util.Log4jLogStreamFactory".equals(clazz) ? (LogFactory)LogFactory.class.cast(tccl.loadClass("org.apache.tomee.loader.log.Log4jLogFactory").newInstance()) : ("org.apache.openejb.util.Slf4jLogStreamFactory".equals(clazz) ? (LogFactory)LogFactory.class.cast(tccl.loadClass("org.apache.tomee.loader.log.Slf4jLogFactory").newInstance()) : null);
            if (factory != null) {
                LogFactory oldFactory = TomEELogConfigurer.getFactory();
                ArrayList<String> names = new ArrayList<String>(oldFactory.getNames());
                oldFactory.getNames().clear();
                oldFactory.release();
                TomEELogConfigurer.setSingleton(factory);
                TomEELogConfigurer.reload(factory, tccl, names);
            }
        }
        catch (Throwable th) {
            System.err.println(th.getClass().getName() + ": " + th.getMessage());
        }
    }

    private static void reload(LogFactory factory, ClassLoader tccl, Collection<String> names) {
        for (String name : names) {
            try {
                Field f = Class.forName(name, false, tccl).getDeclaredField("log");
                if (!Log.class.equals(f.getType())) continue;
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                Log newValue = factory.getInstance(name);
                int modifiers = f.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(f, modifiers & 0xFFFFFFEF);
                    f.set(null, newValue);
                    modifiersField.setInt(f, modifiers & 0x10);
                } else {
                    f.set(null, newValue);
                }
                f.setAccessible(acc);
            }
            catch (Throwable e) {}
        }
    }

    private TomEELogConfigurer() {
    }
}

