/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.tomee.loader.EmbeddedJarScanner;

public class TomEEJarScanner
extends StandardJarScanner {
    private static final Log log = LogFactory.getLog(StandardJarScanner.class);
    protected static final Set<String[]> DEFAULT_JARS_TO_SKIP;
    private static final StringManager sm;

    public void scan(ServletContext context, ClassLoader classLoader, JarScannerCallback callback, Set<String> jarsToIgnore) {
        if ("FragmentJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            EmbeddedJarScanner embeddedJarScanner = new EmbeddedJarScanner();
            embeddedJarScanner.scan(context, classLoader, callback, jarsToIgnore);
        } else if ("TldJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            Set dirList = context.getResourcePaths("/WEB-INF/lib/");
            if (dirList != null) {
                for (String path : dirList) {
                    if (path.endsWith(".jar") && !Matcher.matchPath(DEFAULT_JARS_TO_SKIP, (String)path.substring(path.lastIndexOf(47) + 1))) {
                        URL url = null;
                        try {
                            String realPath = context.getRealPath(path);
                            url = realPath == null ? context.getResource(path) : new File(realPath).toURI().toURL();
                            this.process(callback, url);
                        }
                        catch (IOException e) {
                            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url}), (Throwable)e);
                        }
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", new Object[]{path}));
                }
            }
            if (this.isScanClassPath()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("jarScan.classloaderStart"));
                }
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Set tldFileUrls = TldScanner.scan((ClassLoader)loader);
                    Set<URL> jarUlrs = this.discardFilePaths(tldFileUrls);
                    for (URL url : jarUlrs) {
                        String jarName = this.getJarName(url);
                        if (jarName != null && !Matcher.matchPath(DEFAULT_JARS_TO_SKIP, (String)jarName) && !url.toString().contains("/WEB-INF/lib/" + jarName)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)sm.getString("jarScan.classloaderJarScan", new Object[]{url}));
                            }
                            try {
                                this.process(callback, url);
                            }
                            catch (IOException ioe) {
                                log.warn((Object)sm.getString("jarScan.classloaderFail", new Object[]{url}), (Throwable)ioe);
                            }
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", new Object[]{url}));
                    }
                }
                catch (OpenEJBException e) {
                    log.warn((Object)"JarScan.TldScan Failed ", (Throwable)e);
                }
            }
        } else {
            super.scan(context, classLoader, callback, jarsToIgnore);
        }
    }

    private Set<URL> discardFilePaths(Set<URL> tldFileUrls) {
        HashSet<String> jarPaths = new HashSet<String>();
        for (URL tldFileUrl : tldFileUrls) {
            jarPaths.add(URLs.toFilePath((URL)tldFileUrl));
        }
        HashSet<URL> jars = new HashSet<URL>();
        for (String jarPath : jarPaths) {
            try {
                URL url = new File(jarPath).toURI().toURL();
                jars.add(url);
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Skipping JAR file " + jarPath), (Throwable)e);
            }
        }
        return jars;
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", new Object[]{url}));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.isScanAllFiles()) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.isScanAllDirectories() && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(".jar");
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        } else if (this.isScanAllDirectories()) {
            int start = path.lastIndexOf(47);
            name = path.substring(start + 1);
        }
        return name;
    }

    static {
        sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
        HashSet<String> defaultJarsToSkip = new HashSet<String>();
        String jarList = System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        if (jarList != null) {
            StringTokenizer tokenizer = new StringTokenizer(jarList, ",");
            while (tokenizer.hasMoreElements()) {
                defaultJarsToSkip.add(tokenizer.nextToken());
            }
        }
        HashSet<String[]> ignoredJarsTokens = new HashSet<String[]>();
        for (String pattern : defaultJarsToSkip) {
            ignoredJarsTokens.add(Matcher.tokenizePathAsArray((String)pattern));
        }
        DEFAULT_JARS_TO_SKIP = ignoredJarsTokens;
    }
}

